
package com.ovopark.training.enhancer.subject.alarm;

import lombok.Data;
import org.springframework.util.DigestUtils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;

@Data
public class Image {
    private String base64;
    private String md5;

    public Image(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write(bufferedImage, "png", baos);
        byte[] bytes = baos.toByteArray();
        Base64.Encoder encoder = Base64.getEncoder();
        String pngBase64 = encoder.encodeToString(bytes).trim();
        String md5 = DigestUtils.md5DigestAsHex(bytes);
        this.base64 = pngBase64;
        this.md5 = md5;
    }

}
