//package com.ovopark.training.enhancer.aop;
//
//import com.google.common.collect.Maps;
//import com.ovopark.training.enhancer.subject.debuginfo.DebugInfo;
//import com.ovopark.training.enhancer.subject.debuginfo.DebugInfoContext;
//import com.ovopark.training.enhancer.subject.env.EnvService;
//import com.ovopark.training.enhancer.subject.resp.Result;
//import com.ovopark.training.enhancer.utils.EhContextUtil;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//import org.aspectj.lang.ProceedingJoinPoint;
//import org.aspectj.lang.annotation.Around;
//import org.aspectj.lang.annotation.Aspect;
//import org.aspectj.lang.annotation.Pointcut;
//import org.slf4j.MDC;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Component;
//import org.springframework.stereotype.Service;
//import org.springframework.web.context.request.RequestAttributes;
//import org.springframework.web.context.request.RequestContextHolder;
//import org.springframework.web.context.request.ServletRequestAttributes;
//
//import javax.servlet.http.Cookie;
//import javax.servlet.http.HttpServletRequest;
//import java.util.Enumeration;
//import java.util.Map;
//
///**
// *
// */
//@Slf4j
//@Service
//public class ApiAopService{
//
//    @Autowired
//    private EnvService envService;
//
//    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
//        RequestAttributes ra = RequestContextHolder.getRequestAttributes();
//        ServletRequestAttributes sra = (ServletRequestAttributes) ra;
//        HttpServletRequest request = sra.getRequest();
//
//        String url = request.getRequestURL().toString();
//        String method = request.getMethod();
//        String uri = request.getRequestURI();
//        String params = MDC.get("params");
//        long startTime = System.currentTimeMillis();
////        Map<String, String> headerMap = extractHeader(request);
////        Map<String, String> cookieMap = buildCookieMap(request);
//
//        StringBuilder sb = new StringBuilder();
//        buildOne(sb, "url", url);
//        buildOne(sb, "method", method);
//        buildOne(sb, "uri", uri);
//        buildOne(sb, "param", params);
//        buildOne(sb, "userAgent", request.getHeader("User-Agent"));
//        buildOne(sb, "enterpriseId", EhContextUtil.getEnterpriseId());
//        buildOne(sb, "userId", EhContextUtil.getUserId());
////        buildOne(sb, "header", JSON.toJSONString(headerMap));
////        buildOne(sb, "cookie", JSON.toJSONString(cookieMap));
//        String invokeInfo = sb.toString();
//        log.info(invokeInfo);
//
//        // result的值就是被拦截方法的返回值
//        Object proceed;
//        try {
//            proceed = pjp.proceed();
//        } catch (Throwable e) {
//            throw e;
//        } finally {
//            long cost= System.currentTimeMillis() - startTime;
//            log.info("接口耗时 cost {}", cost);
//        }
////        if (proceed instanceof Result) {
////            if (DebugInfoContext.debugEnable()) {
////                DebugInfo debugInfo = new DebugInfo();
////                debugInfo.setDebugFuncList(DebugInfoContext.getAllFunc());
////                ((Result<?>) proceed).setDebugInfo(debugInfo);
////            }
////        }
//        return proceed;
//    }
//
//    private void buildOne(StringBuilder sb, String key, Object value) {
//        sb.append("\n[").append(key).append(":").append(value).append("]");
//    }
//
//    private static Map<String, String> buildCookieMap(HttpServletRequest httpServletRequest) {
//        Map<String, String> cookieMap = Maps.newHashMap();
//        Cookie[] cookies = httpServletRequest.getCookies();
//        if (null != cookies) {
//            int length = cookies.length;
//
//            for (int i = 0; i < length; ++i) {
//                Cookie cookie = cookies[i];
//                if (!StringUtils.isEmpty(cookie.getValue())) {
//                    cookieMap.put(cookie.getName(), cookie.getValue());
//                } else {
//                    cookieMap.put(cookie.getName(), "");
//                }
//            }
//        }
//        return cookieMap;
//    }
//
//    public static Map<String, String> extractHeader(HttpServletRequest request) {
//        Map<String, String> headerMap = Maps.newHashMap();
//        Enumeration headerNames = request.getHeaderNames();
//
//        while (headerNames.hasMoreElements()) {
//            String headerName = (String) headerNames.nextElement();
//            String headerValue = request.getHeader(headerName);
//            if (!StringUtils.isEmpty(headerValue)) {
//                headerMap.put(headerName, headerValue);
//            }
//        }
//
//        return headerMap;
//    }
//}
