
# 优雅停机

## 背景

在生产环境中,我们经常需要重启或停止应用服务。如果直接强制关闭,可能会导致:

- 正在处理的请求被中断
- 数据库事务未完成导致数据不一致
- 资源未能正常释放
- 缓存数据丢失

因此需要实现优雅停机(Graceful Shutdown)机制。

## 实现原理

1. 注册停机钩子/actuator/shutdowngraceful endpoint
2. 依次调用注册shutdown组件 pause&stop方法 (nacos, kafka, mq...)
3. 延时等待缓存刷新
4. System.exit(0)
5. 完成停机

## Spring Boot 实现

Spring Boot 2.3+ 已经内置了优雅停机的支持,只需要简单配置:

k8s配置直接preStop
```
["/bin/sh","-c","curl --location --request GET 'localhost:port/actuator/shutdowngraceful' ; sleep 30"]
路径端口可自定义
```
