/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.filegateway.common;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.filegateway.common.FileUploadRequest;
import com.zhongan.filegateway.common.FileUploadResponse;
import com.zhongan.filegateway.utils.ErrorCodeEnum;
import com.zhongan.filegateway.utils.FileGatewayEnvEnum;
import com.zhongan.filegateway.utils.FileGatewayHttpUtil;
import com.zhongan.filegateway.utils.MD5Util;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import com.zhongan.scorpoin.signature.StringUtils;
import com.zhongan.scorpoin.util.ZhongAnOpenHttpUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileGatewayOldClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileGatewayOldClient.class);
    private String env;
    private String policyUrl = "/getPolicy";
    private String callbackUrl = "/callback";
    private String url;
    private JSONObject headerParam = new JSONObject();
    private int connectTimeout = 0;
    private int readTimeout = 0;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public FileGatewayOldClient(String env, String url) {
        this.env = env;
        this.url = url;
    }

    public FileUploadResponse call(FileUploadRequest req) {
        FileUploadResponse response = new FileUploadResponse();
        try {
            if (null == req) {
                throw new ZhongAnOpenException(ErrorCodeEnum.PARAM_IS_NULL.getCode(), ErrorCodeEnum.PARAM_IS_NULL.getDescription());
            }
            req.check();
            this._init(req.getAppKey());
            HashMap<String, String> params = new HashMap<String, String>();
            for (Map.Entry en : this.headerParam.entrySet()) {
                params.put((String)en.getKey(), (String)en.getValue());
            }
            String fileNames = req.getFileNames();
            params.put("fileNames", fileNames);
            Object[] obj = ZhongAnOpenHttpUtils.doPost(this.url + this.policyUrl, params, this.connectTimeout, this.readTimeout);
            String res = (String)obj[0];
            JSONObject objres = JSONObject.parseObject((String)res);
            String data = objres.getString("data");
            JSONObject resObj = JSONObject.parseObject((String)data);
            HashMap<String, String> ossParam = new HashMap<String, String>(5);
            String keys = resObj.getString("keys");
            String ossUrl = resObj.getString("host");
            String[] keyArr = keys.split(",");
            String[] nameArr = fileNames.split(",");
            ossParam.put("policy", resObj.getString("policy"));
            ossParam.put("OSSAccessKeyId", resObj.getString("accessid"));
            ossParam.put("success_action_status", "200");
            ossParam.put("signature", resObj.getString("signature"));
            int i = 0;
            Map<String, File> files = req.getFiles();
            String size = "";
            for (String key : keyArr) {
                ossParam.put("key", req.getAppKey() + "/" + key + "_" + nameArr[i]);
                HashMap<String, File> file = new HashMap<String, File>(1);
                File temp = files.get(nameArr[i]);
                file.put(nameArr[i], temp);
                size = size + temp.length() + ",";
                FileGatewayHttpUtil.doPost(ossUrl, this.headerParam, ossParam, file, this.connectTimeout, this.readTimeout);
                ++i;
            }
            params.put("keys", keys);
            params.put("sizes", size.substring(0, size.length() - 1));
            Object[] obj2 = ZhongAnOpenHttpUtils.doPost(this.url + this.callbackUrl, params, this.connectTimeout, this.readTimeout);
            String postResult = (String)obj2[0];
            if (StringUtils.isEmpty(postResult)) {
                throw new ZhongAnOpenException(ErrorCodeEnum.RESPONSE_IS_NULL.getCode(), ErrorCodeEnum.RESPONSE_IS_NULL.getDescription());
            }
            response = (FileUploadResponse)JSONObject.parseObject((String)postResult, FileUploadResponse.class);
            if (ErrorCodeEnum.SUCCESS.getCode().equals(response.getCode())) {
                this._checkMD5Sign(response);
            }
        }
        catch (ZhongAnOpenException e) {
            response.setCode(e.getErrCode());
            response.setMsg(e.getErrMsg());
        }
        catch (Exception e) {
            response.setCode(ErrorCodeEnum.SYS_ERROR.getCode());
            response.setMsg(e.getMessage());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(response.toString());
        }
        return response;
    }

    private void _init(String appKey) throws ZhongAnOpenException {
        if (StringUtils.isEmpty(this.env)) {
            throw new ZhongAnOpenException(ErrorCodeEnum.ENV_IS_NULL.getCode(), ErrorCodeEnum.ENV_IS_NULL.getDescription());
        }
        FileGatewayEnvEnum envEnum = FileGatewayEnvEnum.get(this.env);
        if (null == envEnum) {
            throw new ZhongAnOpenException(ErrorCodeEnum.ENV_ILLEGAL.getCode(), ErrorCodeEnum.ENV_ILLEGAL.getDescription());
        }
        if (FileGatewayEnvEnum.TST.getEnvCode().equals(this.env)) {
            if (StringUtils.isEmpty(this.url)) {
                this.url = FileGatewayEnvEnum.TST.getUrl();
            }
        } else {
            this.url = envEnum.getUrl();
        }
        this.url = this.url.replace("/upload", "");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        this.headerParam.put("appKey", (Object)appKey);
        this.headerParam.put("timestamp", (Object)sdf.format(new Date()));
        this.headerParam.put("sign", (Object)this._signByMD5());
        sdf = null;
    }

    private String _signByMD5() throws ZhongAnOpenException {
        StringBuffer preSign = new StringBuffer("appKey=");
        preSign.append(this.headerParam.getString("appKey"));
        preSign.append("&timestamp=");
        preSign.append(this.headerParam.getString("timestamp"));
        preSign.append("|filegw.zhonganon.com");
        return MD5Util.sign(preSign.toString());
    }

    private void _checkMD5Sign(FileUploadResponse response) throws ZhongAnOpenException {
        String format = "code=%s&data=%s&timestamp=%s|filegw.zhonganon.com";
        String s = String.format(format, response.getCode(), response.getData(), response.getTimestamp());
        String sign = MD5Util.sign(s);
        if (!sign.equals(response.getSign())) {
            throw new ZhongAnOpenException(ErrorCodeEnum.CHECK_SIGN_FAIL.getCode(), ErrorCodeEnum.CHECK_SIGN_FAIL.getDescription());
        }
    }

    public static void main(String[] args) throws Exception {
        long start = System.currentTimeMillis();
        FileGatewayOldClient client = new FileGatewayOldClient("tst", "http://filegw-daily.zhongan.com/file/upload");
        FileUploadRequest req = new FileUploadRequest();
        req.setAppKey("d3c1c50487370acd3407cd5561209eda");
        File file = new File("d:/filegw/5.json");
        File file2 = new File("d:/filegw/2.txt");
        req.addFile(file);
        req.addFile(file2);
        FileUploadResponse response = client.call(req);
        System.out.println(System.currentTimeMillis() - start);
        System.out.println(response);
    }
}

