/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.filegateway.common;

import com.zhongan.filegateway.utils.ErrorCodeEnum;
import com.zhongan.filegateway.utils.FileCheckUtil;
import com.zhongan.filegateway.utils.FileTypeHeaderEnum;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import com.zhongan.scorpoin.signature.StringUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadRequest
implements Serializable {
    private static final long serialVersionUID = 2928657871176162844L;
    private String appKey = null;
    private Map<String, File> files = new HashMap<String, File>();

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    protected void check() throws ZhongAnOpenException {
        if (StringUtils.isEmpty(this.appKey)) {
            throw new ZhongAnOpenException(ErrorCodeEnum.APPKEY_IS_NULL.getCode(), ErrorCodeEnum.APPKEY_IS_NULL.getDescription());
        }
        if (0 == this.files.size()) {
            throw new ZhongAnOpenException(ErrorCodeEnum.FILE_IS_NULL.getCode(), ErrorCodeEnum.FILE_IS_NULL.getDescription());
        }
        ArrayList<String> blackList = new ArrayList<String>();
        blackList.add(FileTypeHeaderEnum.EXE.getType());
        blackList.add(FileTypeHeaderEnum.BAT.getType());
        for (File file : this.files.values()) {
            if (!file.exists()) {
                throw new ZhongAnOpenException(ErrorCodeEnum.FILE_NOT_EXIST.getCode(), ErrorCodeEnum.FILE_NOT_EXIST.getDescription());
            }
            FileCheckUtil.checkFileTypeBlackList(file, blackList);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public Map<String, File> getFiles() {
        return this.files;
    }

    public String getFileNames() {
        Set<String> names = this.files.keySet();
        String s = "";
        if (null != names && !names.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String name : names) {
                sb.append(name).append(",");
            }
            s = sb.substring(0, sb.length() - 1);
        }
        return s;
    }

    public void addFile(String fileName, File file) {
        this.files.put(fileName, file);
    }

    public void addFile(File file) {
        this.files.put(file.getName(), file);
    }
}

