/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.filegateway.utils;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.filegateway.utils.ErrorCodeEnum;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGatewayHttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileGatewayHttpUtil.class);
    private static final String PREFIX = "--";
    private static final String LINEND = "\r\n";
    private static final String BOUNDARY = UUID.randomUUID().toString();

    public static String doPost(String url, JSONObject headerParam, Map<String, String> params, Map<String, File> files, int connectTimeout, int readTimeout) throws ZhongAnOpenException {
        FilterOutputStream outStream = null;
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("connection", "keep-alive");
            conn.setRequestProperty("Charset", "UTF-8");
            conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + BOUNDARY);
            if (null != headerParam) {
                for (Map.Entry entry : headerParam.entrySet()) {
                    conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            outStream = new DataOutputStream(conn.getOutputStream());
            if (params != null) {
                StringBuilder sb1 = new StringBuilder();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    sb1.append(PREFIX);
                    sb1.append(BOUNDARY);
                    sb1.append(LINEND);
                    sb1.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"" + LINEND);
                    sb1.append(LINEND);
                    sb1.append(entry.getValue());
                    sb1.append(LINEND);
                }
                String string = sb1.toString();
                outStream.write(string.getBytes("utf-8"));
            }
            if (files != null) {
                for (Map.Entry entry : files.entrySet()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(PREFIX);
                    stringBuilder.append(BOUNDARY);
                    stringBuilder.append(LINEND);
                    stringBuilder.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + (String)entry.getKey() + "\"" + LINEND);
                    stringBuilder.append("Content-Type: application/octet-stream; charset=UTF-8\r\n");
                    stringBuilder.append(LINEND);
                    outStream.write(stringBuilder.toString().getBytes());
                    FileInputStream is = new FileInputStream((File)entry.getValue());
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    while ((len = ((InputStream)is).read(buffer)) != -1) {
                        ((DataOutputStream)outStream).write(buffer, 0, len);
                    }
                    ((InputStream)is).close();
                    outStream.write(LINEND.getBytes());
                }
            }
            byte[] end_data = (PREFIX + BOUNDARY + PREFIX + LINEND).getBytes();
            outStream.write(end_data);
            ((DataOutputStream)outStream).flush();
            int n = conn.getResponseCode();
            InputStream inputStream = conn.getInputStream();
            StringBuffer resultBuffer = new StringBuffer();
            if (n == 200) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String line = "";
                while ((line = bufferedReader.readLine()) != null) {
                    resultBuffer.append(line);
                }
            } else {
                throw new ZhongAnOpenException(ErrorCodeEnum.HTTP_FAILED.getCode(), String.valueOf(n));
            }
            String string = resultBuffer.toString();
            return string;
        }
        catch (MalformedURLException e) {
            throw new ZhongAnOpenException(ErrorCodeEnum.HTTP_FAILED.getCode(), e.getMessage());
        }
        catch (IOException e) {
            throw new ZhongAnOpenException(ErrorCodeEnum.HTTP_FAILED.getCode(), e.getMessage());
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(ErrorCodeEnum.SYS_ERROR.getCode(), e.getMessage());
        }
        finally {
            if (null != outStream) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
    }
}

