/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.filegateway.utils;

import com.zhongan.filegateway.utils.ErrorCodeEnum;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import com.zhongan.scorpoin.common.enums.SaltTypeEnum;
import com.zhongan.scorpoin.signature.StringUtils;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.digest.DigestUtils;

public class MD5Util {
    public static String sign(String preSign) throws ZhongAnOpenException {
        if (StringUtils.isEmpty(preSign)) {
            throw new ZhongAnOpenException(ErrorCodeEnum.PRESIGN_IS_NULL.getCode(), "\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            return DigestUtils.md5Hex((byte[])preSign.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ZhongAnOpenException(ErrorCodeEnum.SIGN_FAILED.getCode(), e.getMessage());
        }
    }

    public static String sign(String preSign, String salt, String saltType) throws ZhongAnOpenException {
        if (StringUtils.isEmpty(preSign)) {
            throw new ZhongAnOpenException(ErrorCodeEnum.PRESIGN_IS_NULL.getCode(), "\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String signStr = MD5Util.getSignStri(preSign, salt, saltType);
        try {
            return DigestUtils.md5Hex((byte[])signStr.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new ZhongAnOpenException(ErrorCodeEnum.SIGN_FAILED.getCode(), e.getMessage());
        }
    }

    private static String getSignStri(String preSign, String salt, String saltType) {
        String signStr = "";
        if (SaltTypeEnum.PRE_SALT.getCode().equals(saltType)) {
            signStr = salt + preSign;
        } else if (SaltTypeEnum.SUF_SALT.getCode().equals(saltType)) {
            signStr = preSign + salt;
        } else if (SaltTypeEnum.EQU_SALT.getCode().equals(saltType)) {
            signStr = salt + preSign + salt;
        } else if (SaltTypeEnum.UNEQU_SALT.getCode().equals(saltType)) {
            String[] saltStr = salt.split(",");
            signStr = saltStr[0] + preSign + saltStr[1];
        } else {
            signStr = preSign;
        }
        return signStr;
    }

    public static void checkSign(String preSign, String salt, String saltType, String sign) throws Exception {
        String prdSign = MD5Util.sign(preSign, salt, saltType);
        if (!prdSign.equals(sign)) {
            String content = MD5Util.getSignStri(preSign, salt, saltType);
            throw new Exception("rsaCheck failure: sign=" + sign + ", content=" + content + ",prdSign=" + prdSign);
        }
    }
}

