/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.processor;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.filegateway.utils.MD5Util;
import com.zhongan.scorpoin.common.enums.KeysEnum;
import com.zhongan.scorpoin.common.enums.SystemParameterEnum;
import com.zhongan.scorpoin.processor.AbstractSignProcessor;
import com.zhongan.scorpoin.signature.SignatureUtils;
import com.zhongan.scorpoin.signature.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSAMD5SignProcessor
extends AbstractSignProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RSAMD5SignProcessor.class);

    @Override
    public String checkSignAndDecrypt(Map<String, Object> params, Map<String, String> keys) throws Exception {
        LOG.info("RSAMD5SignProcessor -> checkSignAndDecrypt");
        String salt = keys.get(KeysEnum.SALT.getCode());
        String privateKey = keys.get(KeysEnum.PRK.getCode());
        String saltType = keys.get(KeysEnum.SALT_TYPE.getCode());
        String bizContent = (String)params.get(SystemParameterEnum.BIZ_CONTENT.getCode());
        String sign = (String)params.get(SystemParameterEnum.SIGN.getCode());
        params.remove(SystemParameterEnum.SIGN.getCode());
        String charset = (String)params.get(SystemParameterEnum.CHARSET.getCode());
        if (StringUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        if (!StringUtils.isEmpty(sign)) {
            String content = SignatureUtils.getSignContent(params);
            MD5Util.checkSign(content, salt, saltType, sign);
            LOG.info("\u9a8c\u7b7e\u901a\u8fc7,\u5f00\u59cb\u89e3\u5bc6...");
        }
        return SignatureUtils.rsaDecrypt(bizContent, privateKey, charset);
    }

    @Override
    public JSONObject encrypt(String content, String publicKey, String charset) throws Exception {
        LOG.info("RSAMD5SignProcessor -> encrypt");
        if (null == content) {
            LOG.warn("\u52a0\u5bc6\u5185\u5bb9content\u4e0d\u80fd\u4e3anull");
            throw new Exception("\u52a0\u5bc6\u5185\u5bb9content\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty(publicKey)) {
            LOG.warn("publicKey\u4e0d\u80fd\u4e3a\u7a7a");
            throw new Exception("publicKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject result = new JSONObject();
        result.put(SystemParameterEnum.BIZ_CONTENT.getCode(), (Object)SignatureUtils.rsaEncrypt(content, publicKey, charset));
        return result;
    }

    @Override
    public Map<String, Object> encryptAndSignBySignType(JSONObject paramJSON, Map<String, String> keys) throws Exception {
        String salt = keys.get(KeysEnum.SALT.getCode());
        String zaPublicKey = keys.get(KeysEnum.PK.getCode());
        String saltType = keys.get(KeysEnum.SALT_TYPE.getCode());
        String charset = paramJSON.getString("charset");
        Map<String, Object> businessParamMap = this.buildBizMap((Map<String, Object>)paramJSON);
        JSONObject newMap = this.buildSysMap((Map<String, Object>)paramJSON);
        String jsonString = JSONObject.toJSONString(businessParamMap);
        JSONObject jsonObject = this.encrypt(jsonString, zaPublicKey, charset);
        newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), jsonObject.getString("bizContent"));
        String rsaSign = this.signStr((Map<String, Object>)newMap, salt, saltType);
        newMap.put(SystemParameterEnum.SIGN.getCode(), rsaSign);
        return newMap;
    }

    @Override
    public Map<String, Object> xEncryptAndSignBySignType(JSONObject paramJSON, Map<String, String> keys) throws Exception {
        String salt = keys.get(KeysEnum.SALT.getCode());
        String zaPublicKey = keys.get(KeysEnum.PK.getCode());
        String saltType = keys.get(KeysEnum.SALT_TYPE.getCode());
        String charset = paramJSON.getString("charset");
        Map businessParamMap = (Map)paramJSON.get((Object)"params");
        JSONObject newMap = this.buildSysMap((Map<String, Object>)paramJSON);
        String jsonString = JSONObject.toJSONString((Object)businessParamMap);
        JSONObject jsonObject = this.encrypt(jsonString, zaPublicKey, charset);
        newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), jsonObject.getString("bizContent"));
        String rsaSign = this.signStr((Map<String, Object>)newMap, salt, saltType);
        newMap.put(SystemParameterEnum.SIGN.getCode(), rsaSign);
        return newMap;
    }

    @Override
    public String sign(JSONObject jsonObject, Map<String, String> keys) throws Exception {
        String salt = keys.get(KeysEnum.SALT.getCode());
        String saltType = keys.get(KeysEnum.SALT_TYPE.getCode());
        return this.signStr((Map<String, Object>)jsonObject, salt, saltType);
    }

    private String signStr(Map<String, Object> sortedParams, String salt, String saltType) throws Exception {
        String content = SignatureUtils.getSignContent(sortedParams);
        return MD5Util.sign(content, salt, saltType);
    }
}

