/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.processor;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.scorpoin.common.enums.SystemParameterEnum;
import com.zhongan.scorpoin.processor.AbstractSignProcessor;
import com.zhongan.scorpoin.signature.SHA1SignatureUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SHA1SignProcessor
extends AbstractSignProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SHA1SignProcessor.class);

    @Override
    public Map<String, Object> encryptAndSignBySignType(JSONObject paramJSON, Map<String, String> keys) throws Exception {
        String token = paramJSON.getString("token");
        String productId = paramJSON.getString("productId");
        String timestamp = paramJSON.getString("timestamp");
        String sign = SHA1SignatureUtils.getSign(token, productId, timestamp);
        paramJSON.put("sign", (Object)sign);
        Map<String, Object> businessParamMap = this.buildBizMap((Map<String, Object>)paramJSON);
        JSONObject newMap = this.buildSysMap((Map<String, Object>)paramJSON);
        String bizContent = SHA1SignatureUtils.getSignContent(businessParamMap);
        newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), bizContent);
        return newMap;
    }

    @Override
    public Map<String, Object> xEncryptAndSignBySignType(JSONObject paramJSON, Map<String, String> keys) throws Exception {
        String token = paramJSON.getString("token");
        String productId = paramJSON.getString("productId");
        String timestamp = paramJSON.getString("timestamp");
        String sign = SHA1SignatureUtils.getSign(token, productId, timestamp);
        paramJSON.put("sign", (Object)sign);
        Map businessParamMap = (Map)paramJSON.get((Object)"params");
        JSONObject newMap = this.buildSysMap((Map<String, Object>)paramJSON);
        String bizContent = SHA1SignatureUtils.getSignContent(businessParamMap);
        newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), bizContent);
        return newMap;
    }

    @Override
    public JSONObject encrypt(String content, String publicKey, String charset) throws Exception {
        return null;
    }

    @Override
    public String sign(JSONObject jsonObject, Map<String, String> keys) throws Exception {
        return null;
    }

    @Override
    public String checkSignAndDecrypt(Map<String, Object> params, Map<String, String> keys) throws Exception {
        return null;
    }
}

