/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.signature;

import com.alibaba.fastjson.JSONObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SHA1SignatureUtils {
    public static String getSign(String token, String productId, String timestamp) throws Exception {
        String s = productId + timestamp + token;
        String shaStr = SHA1SignatureUtils.sha1HexString(s);
        return shaStr;
    }

    public static String getSignContent(Map<String, Object> sortedParams) {
        JSONObject js = new JSONObject(sortedParams.size(), true);
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            js.put(key, sortedParams.get(key));
        }
        return js.toJSONString();
    }

    public static String sha1HexString(String sourceText) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(sourceText.getBytes());
        byte[] bytes = messageDigest.digest();
        String result = SHA1SignatureUtils.getHexString(bytes);
        return result;
    }

    private static final String getHexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

