/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.XmlWriter;
import com.qcloud.cos.model.CASJobParameters;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.RestoreObjectRequest;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RequestXmlFactory {
    public static byte[] convertToXmlByteArray(List<PartETag> partETags) {
        XmlWriter xml = new XmlWriter();
        xml.start("CompleteMultipartUpload");
        if (partETags != null) {
            Collections.sort(partETags, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag tag1, PartETag tag2) {
                    if (tag1.getPartNumber() < tag2.getPartNumber()) {
                        return -1;
                    }
                    if (tag1.getPartNumber() > tag2.getPartNumber()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (PartETag partEtag : partETags) {
                xml.start("Part");
                xml.start("PartNumber").value(Integer.toString(partEtag.getPartNumber())).end();
                xml.start("ETag").value(partEtag.getETag()).end();
                xml.end();
            }
        }
        xml.end();
        return xml.getBytes();
    }

    public static byte[] convertToXmlByteArray(RestoreObjectRequest restoreObjectRequest) throws CosClientException {
        XmlWriter xml = new XmlWriter();
        xml.start("RestoreRequest");
        xml.start("Days").value(Integer.toString(restoreObjectRequest.getExpirationInDays())).end();
        CASJobParameters casJobParameters = restoreObjectRequest.getCasJobParameters();
        if (casJobParameters != null) {
            xml.start("CASJobParameters");
            RequestXmlFactory.addIfNotNull(xml, "Tier", casJobParameters.getTier());
            xml.end();
        }
        xml.end();
        return xml.getBytes();
    }

    private static void addIfNotNull(XmlWriter xml, String xmlTag, String value) {
        if (value != null) {
            xml.start(xmlTag).value(value).end();
        }
    }
}

