/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.http;

import com.qcloud.image.ClientConfig;
import com.qcloud.image.exception.AbstractImageException;
import com.qcloud.image.exception.ParamException;
import com.qcloud.image.exception.ServerException;
import com.qcloud.image.exception.UnknownException;
import com.qcloud.image.http.AbstractImageHttpClient;
import com.qcloud.image.http.HttpContentType;
import com.qcloud.image.http.HttpRequest;
import com.squareup.okhttp.Cache;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultImageHttpClient
extends AbstractImageHttpClient {
    private OkHttpClient mOkHttpClient = new OkHttpClient();

    public DefaultImageHttpClient(ClientConfig config) {
        super(config);
    }

    @Override
    public void shutdown() {
        this.mOkHttpClient.getDispatcher().getExecutorService().shutdown();
        ConnectionPool connectionPool = this.mOkHttpClient.getConnectionPool();
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        try {
            Cache cache = this.mOkHttpClient.getCache();
            if (cache != null) {
                cache.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String sendPostRequest(HttpRequest httpRequest) throws AbstractImageException {
        this.mOkHttpClient.setProxy(this.config.getProxy());
        this.mOkHttpClient.setConnectTimeout((long)this.config.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        this.mOkHttpClient.setReadTimeout((long)this.config.getSocketTimeout(), TimeUnit.MILLISECONDS);
        this.mOkHttpClient.setWriteTimeout((long)this.config.getSocketTimeout(), TimeUnit.MILLISECONDS);
        if (httpRequest.getContentType() == HttpContentType.APPLICATION_JSON) {
            String string;
            Map<String, Object> params = httpRequest.getParams();
            JSONObject root = new JSONObject(params);
            String postBody = root.toString();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)postBody);
            Request.Builder requestBuilder = new Request.Builder().url(httpRequest.getUrl()).post(requestBody);
            Map<String, String> headers = httpRequest.getHeaders();
            for (String headerKey : headers.keySet()) {
                requestBuilder.addHeader(headerKey, headers.get(headerKey));
            }
            Response response = null;
            try {
                response = this.mOkHttpClient.newCall(requestBuilder.build()).execute();
            }
            catch (IOException e) {
                throw new ServerException(e);
            }
            if (!response.isSuccessful()) {
                string = null;
                try {
                    string = response.body().string();
                }
                catch (IOException e) {
                    throw new ServerException("Unexpected response code and IOException while reading response string,\n" + response + ",\n" + e.getMessage());
                }
                return string;
            }
            string = null;
            try {
                string = response.body().string();
            }
            catch (IOException e) {
                throw new ServerException("IOException while reading response string.\n" + e.getMessage());
            }
            try {
                new JSONObject(string);
            }
            catch (JSONException e) {
                throw new UnknownException("response is not json: " + string, (Throwable)e);
            }
            return string;
        }
        if (httpRequest.getContentType() == HttpContentType.MULTIPART_FORM_DATA) {
            String string;
            Map<String, byte[]> bytesContentList = httpRequest.getBytesContentList();
            Map<String, File> imageList = bytesContentList != null && bytesContentList.size() > 0 ? Collections.emptyMap() : httpRequest.getImageList();
            Map<String, Object> params = httpRequest.getParams();
            MultipartBuilder multipartBuilder = new MultipartBuilder();
            try {
                this.setMultiPartEntity(multipartBuilder, params, imageList, bytesContentList);
            }
            catch (FileNotFoundException e) {
                throw new ParamException(e);
            }
            RequestBody requestBody = multipartBuilder.build();
            Request.Builder requestBuilder = new Request.Builder().url(httpRequest.getUrl()).post(requestBody);
            Map<String, String> headers = httpRequest.getHeaders();
            for (String headerKey : headers.keySet()) {
                requestBuilder.addHeader(headerKey, headers.get(headerKey));
            }
            requestBuilder.addHeader("Connection", "close");
            Response response = null;
            try {
                response = this.mOkHttpClient.newCall(requestBuilder.build()).execute();
            }
            catch (IOException e) {
                throw new ServerException(e);
            }
            if (!response.isSuccessful()) {
                string = null;
                try {
                    string = response.body().string();
                }
                catch (IOException e) {
                    throw new ServerException("Unexpected response code and IOException while reading response string,\n" + response + ",\n" + e.getMessage());
                }
                return string;
            }
            string = null;
            try {
                string = response.body().string();
            }
            catch (IOException e) {
                throw new ServerException("IOException while reading response string.\n" + e.getMessage());
            }
            try {
                new JSONObject(string);
            }
            catch (JSONException e) {
                throw new UnknownException("response is not json: " + string, (Throwable)e);
            }
            return string;
        }
        throw new ParamException("Unknown ContentType, httpRequest.getContentType():" + (Object)((Object)httpRequest.getContentType()));
    }

    private void setMultiPartEntity(MultipartBuilder multipartBuilder, Map<String, Object> params, Map<String, File> files, Map<String, byte[]> fileContents) throws FileNotFoundException {
        multipartBuilder.type(MultipartBuilder.FORM);
        for (String paramKey : params.keySet()) {
            multipartBuilder.addFormDataPart(paramKey, String.valueOf(params.get(paramKey)));
        }
        if (files.size() > 0) {
            for (String key : files.keySet()) {
                File file = files.get(key);
                if (file == null) {
                    throw new FileNotFoundException("File is null: " + key);
                }
                if (!file.exists()) {
                    throw new FileNotFoundException("File Not Exists: " + file.getAbsolutePath());
                }
                multipartBuilder.addPart(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", key, file.getName())}), RequestBody.create((MediaType)MediaType.parse((String)"image/jpg"), (File)file));
            }
        }
        for (String key : fileContents.keySet()) {
            byte[] content = fileContents.get(key);
            if (content == null || content.length <= 0) continue;
            multipartBuilder.addPart(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", key, "bytes" + System.currentTimeMillis())}), RequestBody.create((MediaType)MediaType.parse((String)"image/jpg"), (byte[])content));
        }
    }
}

