/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.request;

import com.qcloud.image.common_utils.CommonParamCheckUtils;
import com.qcloud.image.exception.ParamException;
import com.qcloud.image.request.AbstractBaseRequest;
import java.io.File;

public class OcrBizLicenseRequest
extends AbstractBaseRequest {
    private boolean isUrl;
    private String url = "";
    private File image;

    public OcrBizLicenseRequest(String bucketName, String url) {
        super(bucketName);
        this.isUrl = true;
        this.url = url;
    }

    public OcrBizLicenseRequest(String bucketName, File image) {
        super(bucketName);
        this.isUrl = false;
        this.image = image;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        if (this.isUrl) {
            CommonParamCheckUtils.AssertNotNull("url", this.url);
        } else {
            CommonParamCheckUtils.AssertNotNull("image content", this.image);
        }
    }

    public boolean isUrl() {
        return this.isUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public File getImage() {
        return this.image;
    }
}

