/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.sign;

import com.qcloud.image.common_utils.CommonCodecUtils;
import com.qcloud.image.exception.AbstractImageException;
import com.qcloud.image.exception.UnknownException;
import com.qcloud.image.sign.Credentials;
import java.util.Random;

public class Sign {
    public static String appSign(Credentials cred, String bucketName, long expired) throws AbstractImageException {
        byte[] hmacDigest;
        String appId = cred.getAppId();
        String secretId = cred.getSecretId();
        String secretKey = cred.getSecretKey();
        long now = System.currentTimeMillis() / 1000L;
        int rdm = Math.abs(new Random().nextInt());
        String plainText = String.format("a=%s&b=%s&k=%s&t=%d&e=%d", appId, bucketName, secretId, now, now + expired);
        try {
            hmacDigest = CommonCodecUtils.HmacSha1(plainText, secretKey);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UnknownException(e);
        }
        byte[] signContent = new byte[hmacDigest.length + plainText.getBytes().length];
        System.arraycopy(hmacDigest, 0, signContent, 0, hmacDigest.length);
        System.arraycopy(plainText.getBytes(), 0, signContent, hmacDigest.length, plainText.getBytes().length);
        return CommonCodecUtils.Base64Encode(signContent);
    }
}

