/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.sse;

import java.io.IOException;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okhttp3.internal.sse.ServerSentEventReader;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;

public final class RealEventSource
implements EventSource,
ServerSentEventReader.Callback,
Callback {
    private final Request request;
    private final EventSourceListener listener;
    @Nullable
    private Call call;

    public RealEventSource(Request request, EventSourceListener listener) {
        this.request = request;
        this.listener = listener;
    }

    public void connect(OkHttpClient client) {
        client = client.newBuilder().eventListener(EventListener.NONE).build();
        this.call = client.newCall(this.request);
        this.call.timeout().clearTimeout();
        this.call.enqueue((Callback)this);
    }

    public void onResponse(Call call, Response response) {
        this.processResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(Response response) {
        try {
            if (!response.isSuccessful()) {
                this.listener.onFailure(this, null, response);
                return;
            }
            ResponseBody body = response.body();
            MediaType contentType = body.contentType();
            if (!RealEventSource.isEventStream(contentType)) {
                this.listener.onFailure(this, new IllegalStateException("Invalid content-type: " + contentType), response);
                return;
            }
            response = response.newBuilder().body(Util.EMPTY_RESPONSE).build();
            ServerSentEventReader reader = new ServerSentEventReader(body.source(), this);
            try {
                this.listener.onOpen(this, response);
                while (reader.processNextEvent()) {
                }
            }
            catch (Exception e) {
                this.listener.onFailure(this, e, response);
                response.close();
                return;
            }
            this.listener.onClosed(this);
        }
        finally {
            response.close();
        }
    }

    private static boolean isEventStream(@Nullable MediaType contentType) {
        return contentType != null && contentType.type().equals("text") && contentType.subtype().equals("event-stream");
    }

    public void onFailure(Call call, IOException e) {
        this.listener.onFailure(this, e, null);
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    @Override
    public void onEvent(@Nullable String id, @Nullable String type, String data) {
        this.listener.onEvent(this, id, type, data);
    }

    @Override
    public void onRetryChange(long timeMs) {
    }
}

