/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.context;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.volcengine.ark.runtime.model.completion.chat.ChatMessage;
import com.volcengine.ark.runtime.model.context.TruncationStrategy;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CreateContextRequest {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="mode")
    private String mode;
    @JsonProperty(value="messages")
    private List<ChatMessage> messages;
    @JsonProperty(value="ttl")
    private Integer ttl;
    @JsonProperty(value="truncation_strategy")
    private TruncationStrategy truncationStrategy;

    public CreateContextRequest() {
    }

    public CreateContextRequest(String model, String mode, List<ChatMessage> messages, Integer ttl, TruncationStrategy truncationStrategy) {
        this.model = model;
        this.mode = mode;
        this.messages = messages;
        this.ttl = ttl;
        this.truncationStrategy = truncationStrategy;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<ChatMessage> messages) {
        this.messages = messages;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public TruncationStrategy getTruncationStrategy() {
        return this.truncationStrategy;
    }

    public void setTruncationStrategy(TruncationStrategy truncationStrategy) {
        this.truncationStrategy = truncationStrategy;
    }

    public String toString() {
        return "CreateContextRequest{model='" + this.model + '\'' + ", mode='" + this.mode + '\'' + ", messages=" + this.messages + ", ttl=" + this.ttl + ", truncationStrategy=" + this.truncationStrategy + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model;
        private String mode;
        private List<ChatMessage> messages;
        private Integer ttl;
        private TruncationStrategy truncationStrategy;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder truncationStrategy(TruncationStrategy truncationStrategy) {
            this.truncationStrategy = truncationStrategy;
            return this;
        }

        public CreateContextRequest build() {
            CreateContextRequest createContextRequest = new CreateContextRequest();
            createContextRequest.setModel(this.model);
            createContextRequest.setMode(this.mode);
            createContextRequest.setMessages(this.messages);
            createContextRequest.setTtl(this.ttl);
            createContextRequest.setTruncationStrategy(this.truncationStrategy);
            return createContextRequest;
        }
    }
}

