/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.interceptor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.volcengine.ark.runtime.service.CertificateManager;
import com.volcengine.ark.runtime.utils.KeyAgreementUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptionInterceptor
implements Interceptor {
    private final String apiKey;
    private final String baseUrl;
    private final ObjectMapper mapper = new ObjectMapper();

    public EncryptionInterceptor(String apiKey, String baseUrl) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String is_encrypt = request.headers().get("x-is-encrypted");
        if (!"true".equals(is_encrypt)) {
            return chain.proceed(request);
        }
        RequestBody originalBody = request.body();
        if (originalBody == null) {
            return chain.proceed(request);
        }
        Map<String, Object> requestBodyJson = this.parseRequestBody(originalBody);
        String model = requestBodyJson.get("model").toString();
        return this.proceedWithEncryption(chain, request, requestBodyJson, model);
    }

    private Response proceedWithEncryption(Interceptor.Chain chain, Request request, Map<String, Object> requestBodyJson, String model) throws IOException {
        KeyAgreementUtil.SessionData sessionData;
        CertificateManager.ServerCertificateInfo certInfo = CertificateManager.getServerCertificate(this.apiKey, this.baseUrl, model);
        if (certInfo == null) {
            throw new IOException("Failed to get server certificate for encryption");
        }
        try {
            sessionData = KeyAgreementUtil.generateEciesKeyPair(certInfo.getPublicKey());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        byte[] e2eKey = sessionData.getCryptoKey();
        byte[] e2eNonce = sessionData.getCryptoNonce();
        String sessionToken = sessionData.getSessionToken();
        RequestBody encryptedBody = this.encryptRequestBody(requestBodyJson, e2eKey, e2eNonce);
        Request.Builder requestBuilder = request.newBuilder().method(request.method(), encryptedBody);
        this.addAiccEncryptionHeader(requestBuilder, certInfo);
        requestBuilder.addHeader("X-Session-Token", sessionToken);
        Request encryptedRequest = requestBuilder.build();
        Response originalResponse = chain.proceed(encryptedRequest);
        if (!originalResponse.isSuccessful()) {
            return this.handleErrorResponse(originalResponse);
        }
        return this.decryptResponse(e2eKey, e2eNonce, originalResponse);
    }

    private Map<String, Object> parseRequestBody(RequestBody body) throws IOException {
        Buffer buffer = new Buffer();
        body.writeTo((BufferedSink)buffer);
        String requestBodyStr = buffer.readString(StandardCharsets.UTF_8);
        return (Map)this.mapper.readValue(requestBodyStr, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    private Response proceedWithoutEncryption(Interceptor.Chain chain, Request request, Map<String, Object> requestBodyJson) throws IOException {
        String modifiedRequestBodyStr = this.mapper.writeValueAsString(requestBodyJson);
        RequestBody modifiedBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)modifiedRequestBodyStr);
        Request modifiedRequest = request.newBuilder().method(request.method(), modifiedBody).build();
        return chain.proceed(modifiedRequest);
    }

    private RequestBody encryptRequestBody(Map<String, Object> requestBodyJson, byte[] e2eKey, byte[] e2eNonce) throws IOException {
        try {
            Object messagesObj = requestBodyJson.get("messages");
            if (messagesObj instanceof List) {
                List messagesList = (List)messagesObj;
                ArrayList<Map<String, Object>> processedMessages = new ArrayList<Map<String, Object>>();
                for (Object message : messagesList) {
                    if (!(message instanceof Map)) continue;
                    Map messageMap = (Map)message;
                    processedMessages.add(this.processMessage(messageMap, e2eKey, e2eNonce));
                }
                requestBodyJson.put("messages", processedMessages);
            }
            String modifiedRequestBodyStr = this.mapper.writeValueAsString(requestBodyJson);
            return RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)modifiedRequestBodyStr);
        }
        catch (Exception e) {
            throw new IOException("Failed to process request body", e);
        }
    }

    private Map<String, Object> processMessage(Map<String, Object> message, byte[] e2eKey, byte[] e2eNonce) throws IOException {
        Object content = message.get("content");
        if (content != null) {
            message.put("content", this.processMessageContent(content, e2eKey, e2eNonce));
        }
        return message;
    }

    private Object processMessageContent(Object content, byte[] e2eKey, byte[] e2eNonce) throws IOException {
        if (content instanceof String) {
            return KeyAgreementUtil.encryptStringWithKey(e2eKey, e2eNonce, (String)content);
        }
        if (content instanceof Iterable) {
            ArrayList<Map<String, Object>> processedParts = new ArrayList<Map<String, Object>>();
            for (Object part : (Iterable)content) {
                if (part instanceof Map) {
                    Map partMap = (Map)part;
                    processedParts.add(this.processContentPart(partMap, e2eKey, e2eNonce));
                    continue;
                }
                throw new IOException("encryption is not supported for content type " + part.getClass().getSimpleName());
            }
            return processedParts;
        }
        throw new IOException("encryption is not supported for content type " + content.getClass().getSimpleName());
    }

    private Map<String, Object> processContentPart(Map<String, Object> part, byte[] e2eKey, byte[] e2eNonce) throws IOException {
        String type;
        switch (type = part.get("type").toString()) {
            case "text": {
                part.put("text", KeyAgreementUtil.encryptStringWithKey(e2eKey, e2eNonce, part.get("text").toString()));
                break;
            }
            case "image_url": {
                Map imageUrl = (Map)part.get("image_url");
                this.processImageUrl(imageUrl, e2eKey, e2eNonce);
                break;
            }
            default: {
                throw new IOException("encryption is not supported for content type " + type);
            }
        }
        return part;
    }

    private void processImageUrl(Map<String, Object> imageUrl, byte[] e2eKey, byte[] e2eNonce) throws IOException {
        block5: {
            String url = imageUrl.get("url").toString();
            try {
                URI uri = new URI(url);
                String scheme = uri.getScheme();
                if ("data".equals(scheme)) {
                    imageUrl.put("url", KeyAgreementUtil.encryptStringWithKey(e2eKey, e2eNonce, url));
                    break block5;
                }
                if ("http".equals(scheme) || "https".equals(scheme)) {
                    System.err.println("WARNING: encryption is not supported for image url, please use base64 image if you want encryption");
                    break block5;
                }
                throw new IOException("encryption is not supported for image url scheme " + scheme);
            }
            catch (URISyntaxException e) {
                if (url.startsWith("data:")) {
                    imageUrl.put("url", KeyAgreementUtil.encryptStringWithKey(e2eKey, e2eNonce, url));
                }
                throw new IOException("Invalid image URL format: " + url, e);
            }
        }
    }

    private void addAiccEncryptionHeader(Request.Builder requestBuilder, CertificateManager.ServerCertificateInfo certInfo) throws IOException {
        String volcArkEncryption = System.getenv("VOLC_ARK_ENCRYPTION");
        boolean aiccEnabled = "AICC".equals(volcArkEncryption);
        if (aiccEnabled) {
            HashMap<String, String> info = new HashMap<String, String>();
            info.put("Version", "AICCv0.1");
            info.put("RingID", certInfo.getRingId());
            info.put("KeyID", certInfo.getKeyId());
            String infoJson = this.mapper.writeValueAsString(info);
            requestBuilder.addHeader("X-Encrypt-Info", infoJson);
        }
    }

    private Response handleErrorResponse(Response response) throws IOException {
        ResponseBody errorBody = response.body();
        if (errorBody != null) {
            String errorResponseStr = errorBody.string();
            MediaType contentType = errorBody.contentType();
            if (contentType == null) {
                contentType = MediaType.get((String)"application/json; charset=utf-8");
            }
            ResponseBody newErrorBody = ResponseBody.create((MediaType)contentType, (String)errorResponseStr);
            return response.newBuilder().body(newErrorBody).build();
        }
        return response;
    }

    /*
     * Loose catch block
     */
    private Response decryptResponse(byte[] key, byte[] nonce, Response response) {
        String responseBodyStr;
        block6: {
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                return response;
            }
            responseBodyStr = responseBody.string();
            if (!this.isStreamResponseFromContent(responseBodyStr)) break block6;
            return this.handleStreamResponse(key, nonce, response, responseBodyStr);
            {
                catch (Exception e) {
                    return response;
                }
            }
        }
        try {
            Map responseJson = (Map)this.mapper.readValue(responseBodyStr, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return this.handleNormalResponse(key, nonce, response, responseJson);
        }
        catch (Exception e) {
            return this.handleStreamResponse(key, nonce, response, responseBodyStr);
        }
    }

    private Response handleStreamResponse(byte[] key, byte[] nonce, Response response, String originalContent) {
        try {
            ResponseBody originalBody = response.body();
            if (originalBody == null) {
                return response;
            }
            String decryptedContent = this.decryptStreamContent(key, nonce, originalContent);
            MediaType contentType = originalBody.contentType();
            if (contentType == null) {
                contentType = MediaType.get((String)"application/json; charset=utf-8");
            }
            ResponseBody decryptedBody = ResponseBody.create((MediaType)contentType, (byte[])decryptedContent.getBytes(StandardCharsets.UTF_8));
            return response.newBuilder().body(decryptedBody).build();
        }
        catch (Exception e) {
            return response;
        }
    }

    private Response handleNormalResponse(byte[] key, byte[] nonce, Response response, Map<String, Object> responseJson) throws IOException {
        if (responseJson.containsKey("choices") && responseJson.get("choices") instanceof List) {
            List choices = (List)responseJson.get("choices");
            for (Map choice : choices) {
                if (!this.shouldDecryptChoice(choice)) continue;
                this.decryptChoiceContent(key, nonce, choice);
            }
        }
        String decryptedContent = this.mapper.writeValueAsString(responseJson);
        ResponseBody originalResponseBody = response.body();
        MediaType contentType = null;
        if (originalResponseBody != null) {
            contentType = originalResponseBody.contentType();
        }
        if (contentType == null) {
            contentType = MediaType.get((String)"application/json; charset=utf-8");
        }
        ResponseBody decryptedBody = ResponseBody.create((MediaType)contentType, (byte[])decryptedContent.getBytes(StandardCharsets.UTF_8));
        return response.newBuilder().body(decryptedBody).build();
    }

    private void decryptChoiceContent(byte[] key, byte[] nonce, Map<String, Object> choice) {
        String encryptedContent = this.getEncryptedContentFromChoice(choice);
        if (encryptedContent != null && !encryptedContent.isEmpty()) {
            try {
                String decryptedContent = KeyAgreementUtil.decryptStringWithKey(key, nonce, encryptedContent);
                Map message = (Map)choice.get("message");
                message.put("content", decryptedContent);
            }
            catch (Exception e) {
                Map message = (Map)choice.get("message");
                message.put("content", "");
            }
        }
    }

    private String decryptStreamContent(byte[] key, byte[] nonce, String streamContent) {
        try {
            String[] lines = streamContent.split("\n");
            StringBuilder decryptedContent = new StringBuilder();
            for (String line : lines) {
                if (line.trim().isEmpty()) {
                    decryptedContent.append(line).append("\n");
                    continue;
                }
                if (line.startsWith("data: ")) {
                    String dataContent = line.substring(6);
                    if ("[DONE]".equals(dataContent)) {
                        decryptedContent.append("data: [DONE]\n");
                        continue;
                    }
                    try {
                        Map chunkData = (Map)this.mapper.readValue(dataContent, Map.class);
                        Map<String, Object> decryptedChunk = this.decryptStreamChunk(key, nonce, chunkData);
                        String decryptedJson = this.mapper.writeValueAsString(decryptedChunk);
                        decryptedContent.append("data: ").append(decryptedJson).append("\n");
                    }
                    catch (Exception e) {
                        decryptedContent.append(line).append("\n");
                    }
                    continue;
                }
                decryptedContent.append(line).append("\n");
            }
            return decryptedContent.toString();
        }
        catch (Exception e) {
            return streamContent;
        }
    }

    private Map<String, Object> decryptStreamChunk(byte[] key, byte[] nonce, Map<String, Object> chunkData) {
        try {
            if (!this.hasValidChoices(chunkData)) {
                return chunkData;
            }
            List choices = (List)chunkData.get("choices");
            for (Map choice : choices) {
                this.decryptStreamChoiceContent(key, nonce, choice);
            }
            return chunkData;
        }
        catch (Exception e) {
            return chunkData;
        }
    }

    private boolean hasValidChoices(Map<String, Object> chunkData) {
        return chunkData.containsKey("choices") && chunkData.get("choices") instanceof List;
    }

    private void decryptStreamChoiceContent(byte[] key, byte[] nonce, Map<String, Object> choice) {
        if (!this.shouldDecryptStreamChoice(choice)) {
            return;
        }
        String encryptedContent = this.getEncryptedContentFromStreamChoice(choice);
        if (encryptedContent == null || encryptedContent.isEmpty()) {
            return;
        }
        try {
            String decryptedContent = KeyAgreementUtil.aesGcmDecryptBase64String(key, nonce, encryptedContent);
            this.updateStreamChoiceContent(choice, decryptedContent);
        }
        catch (Exception e) {
            this.updateStreamChoiceContent(choice, "");
        }
    }

    private void updateStreamChoiceContent(Map<String, Object> choice, String content) {
        Map delta = (Map)choice.get("delta");
        delta.put("content", content);
    }

    private boolean isStreamResponseFromContent(String content) {
        if (content == null || content.trim().isEmpty()) {
            return false;
        }
        if (content.trim().startsWith("data: ")) {
            return true;
        }
        return content.contains("\ndata: ") || content.contains("\r\ndata: ");
    }

    private boolean shouldDecryptChoice(Map<String, Object> choice) {
        if (!choice.containsKey("message") || !(choice.get("message") instanceof Map)) {
            return false;
        }
        Map message = (Map)choice.get("message");
        String finishReason = (String)choice.get("finish_reason");
        if ("content_filter".equals(finishReason)) {
            return false;
        }
        if (message == null || message.isEmpty()) {
            return false;
        }
        Object content = message.get("content");
        return content instanceof String;
    }

    private String getEncryptedContentFromChoice(Map<String, Object> choice) {
        Map message = (Map)choice.get("message");
        return (String)message.get("content");
    }

    private boolean shouldDecryptStreamChoice(Map<String, Object> choice) {
        if (!choice.containsKey("delta") || !(choice.get("delta") instanceof Map)) {
            return false;
        }
        Map delta = (Map)choice.get("delta");
        String finishReason = (String)choice.get("finish_reason");
        if ("content_filter".equals(finishReason)) {
            return false;
        }
        if (delta == null || delta.isEmpty()) {
            return false;
        }
        Object content = delta.get("content");
        return content instanceof String;
    }

    private String getEncryptedContentFromStreamChoice(Map<String, Object> choice) {
        Map delta = (Map)choice.get("delta");
        return (String)delta.get("content");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

