/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.example;

import com.yunzhanghu.example.config.Config;
import com.yunzhanghu.example.utils.BaseUtil;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.calculatelabor.CalculateLaborServiceClient;
import com.yunzhanghu.sdk.calculatelabor.domain.CalcTaxRequest;
import com.yunzhanghu.sdk.calculatelabor.domain.CalcTaxResponse;
import com.yunzhanghu.sdk.calculatelabor.domain.CalculationH5UrlRequest;
import com.yunzhanghu.sdk.calculatelabor.domain.CalculationH5UrlResponse;
import com.yunzhanghu.sdk.calculatelabor.domain.CalculationYearH5UrlRequest;
import com.yunzhanghu.sdk.calculatelabor.domain.CalculationYearH5UrlResponse;
import com.yunzhanghu.sdk.calculatelabor.domain.LaborCaculatorRequest;
import com.yunzhanghu.sdk.calculatelabor.domain.LaborCaculatorResponse;
import com.yunzhanghu.sdk.calculatelabor.domain.MonthSettlement;

public class CalculateLabor {
    private static YzhConfig config = Config.getYzhConfig();
    private static CalculateLaborServiceClient client = new CalculateLaborServiceClient(config);

    public static void main(String[] args) {
        CalculateLabor.laborCaculator();
        CalculateLabor.calcTax();
        CalculateLabor.calculationYearH5Url();
        CalculateLabor.calculationH5Url();
    }

    private static void laborCaculator() {
        LaborCaculatorRequest request = new LaborCaculatorRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setMonthSettlementList(CalculateLabor.getMonthSettlementList());
        YzhResponse<LaborCaculatorResponse> response = null;
        try {
            response = client.laborCaculator(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                LaborCaculatorResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static MonthSettlement[] getMonthSettlementList() {
        MonthSettlement info1 = new MonthSettlement();
        info1.setMonth(1);
        info1.setMonthPreTaxAmount("10.00");
        MonthSettlement info2 = new MonthSettlement();
        info2.setMonth(2);
        info2.setMonthPreTaxAmount("10.00");
        MonthSettlement[] infoArry = new MonthSettlement[]{info1, info2};
        return infoArry;
    }

    private static void calcTax() {
        CalcTaxRequest request = new CalcTaxRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setRealName("\u5f20\u4e09");
        request.setIdCard("11010519491231002X");
        request.setPay("99");
        request.setTaxType("after_tax");
        YzhResponse<CalcTaxResponse> response = null;
        try {
            response = client.calcTax(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CalcTaxResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void calculationYearH5Url() {
        CalculationYearH5UrlRequest request = new CalculationYearH5UrlRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setColor("#FF3D3D");
        YzhResponse<CalculationYearH5UrlResponse> response = null;
        try {
            response = client.calculationYearH5Url(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CalculationYearH5UrlResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void calculationH5Url() {
        CalculationH5UrlRequest request = new CalculationH5UrlRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setColor("#FF3D3D");
        request.setRealName("\u5f20\u4e09");
        request.setIdCard("11010519491231002X");
        YzhResponse<CalculationH5UrlResponse> response = null;
        try {
            response = client.calculationH5Url(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                CalculationH5UrlResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + "-" + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

