/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.example;

import com.yunzhanghu.example.config.Config;
import com.yunzhanghu.example.utils.BaseUtil;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.dataservice.DataServiceClient;
import com.yunzhanghu.sdk.dataservice.domain.DealerBillInfo;
import com.yunzhanghu.sdk.dataservice.domain.DealerOrderInfo;
import com.yunzhanghu.sdk.dataservice.domain.DealerOrderInfoV2;
import com.yunzhanghu.sdk.dataservice.domain.GetDailyBillFileV2Request;
import com.yunzhanghu.sdk.dataservice.domain.GetDailyBillFileV2Response;
import com.yunzhanghu.sdk.dataservice.domain.GetDailyOrderFileRequest;
import com.yunzhanghu.sdk.dataservice.domain.GetDailyOrderFileResponse;
import com.yunzhanghu.sdk.dataservice.domain.GetDailyOrderFileV2Request;
import com.yunzhanghu.sdk.dataservice.domain.GetDailyOrderFileV2Response;
import com.yunzhanghu.sdk.dataservice.domain.ListBalanceDailyStatementRequest;
import com.yunzhanghu.sdk.dataservice.domain.ListBalanceDailyStatementResponse;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyBillRequest;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyBillResponse;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyOrderRequest;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyOrderResponse;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyOrderSummary;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyOrderSummaryRequest;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyOrderSummaryResponse;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyOrderV2Request;
import com.yunzhanghu.sdk.dataservice.domain.ListDailyOrderV2Response;
import com.yunzhanghu.sdk.dataservice.domain.ListDealerRechargeRecordV2Request;
import com.yunzhanghu.sdk.dataservice.domain.ListMonthlyOrderSummaryRequest;
import com.yunzhanghu.sdk.dataservice.domain.ListMonthlyOrderSummaryResponse;
import com.yunzhanghu.sdk.dataservice.domain.RechargeRecordInfo;
import com.yunzhanghu.sdk.dataservice.domain.StatementDetail;
import java.util.List;

public class DataService {
    private static YzhConfig config = Config.getYzhConfig();
    private static DataServiceClient client = new DataServiceClient(config);

    public static void main(String[] args) {
        DataService.getDailyOrderFile();
        DataService.getDailyBillFileV2();
        DataService.listDealerRechargeRecordV2();
        DataService.listDailyOrder();
        DataService.listDailyOrderV2();
        DataService.getDailyOrderFileV2();
        DataService.listDailyBill();
        DataService.listBalanceDailyStatement();
        DataService.listDailyOrderSummary();
        DataService.listMonthlyOrderSummary();
    }

    private static void getDailyOrderFile() {
        GetDailyOrderFileRequest request = new GetDailyOrderFileRequest();
        request.setOrderDate("2020-11-11");
        YzhResponse<GetDailyOrderFileResponse> response = null;
        try {
            response = client.getDailyOrderFile(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetDailyOrderFileResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getDailyBillFileV2() {
        GetDailyBillFileV2Request request = new GetDailyBillFileV2Request();
        request.setBillDate("2020-11-11");
        YzhResponse<GetDailyBillFileV2Response> response = null;
        try {
            response = client.getDailyBillFileV2(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetDailyBillFileV2Response data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void listDealerRechargeRecordV2() {
        ListDealerRechargeRecordV2Request request = new ListDealerRechargeRecordV2Request();
        request.setBeginAt("2020-01-02");
        request.setEndAt("2020-01-31");
        YzhResponse<List<RechargeRecordInfo>> response = null;
        try {
            response = client.listDealerRechargeRecordV2(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                List<RechargeRecordInfo> data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\u8fd4\u56de\u6761\u6570 \uff1a" + data.size());
                data.forEach(info -> {
                    System.out.println("---------");
                    System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + info);
                });
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void listDailyOrder() {
        ListDailyOrderRequest request = new ListDailyOrderRequest();
        request.setOrderDate("2020-03-25");
        request.setOffset(0);
        request.setLength(200);
        request.setChannel("\u652f\u4ed8\u5b9d");
        request.setDataType("encryption");
        YzhResponse<ListDailyOrderResponse> response = null;
        try {
            response = client.listDailyOrder(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ListDailyOrderResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\u8fd4\u56de\u6761\u6570\uff1a" + data.getTotalNum());
                for (DealerOrderInfo info : data.getList()) {
                    System.out.println("---------");
                    System.out.println(info);
                }
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void listDailyOrderV2() {
        ListDailyOrderV2Request request = new ListDailyOrderV2Request();
        request.setOrderDate("2024-09-05");
        request.setOffset(0);
        request.setLength(100);
        request.setChannel("alipay");
        request.setDataType("");
        YzhResponse<ListDailyOrderV2Response> response = null;
        try {
            response = client.listDailyOrderV2(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ListDailyOrderV2Response data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\u8fd4\u56de\u6761\u6570\uff1a" + data.getTotalNum());
                for (DealerOrderInfoV2 info : data.getList()) {
                    System.out.println("---------");
                    System.out.println(info);
                }
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getDailyOrderFileV2() {
        GetDailyOrderFileV2Request request = new GetDailyOrderFileV2Request();
        request.setOrderDate("2020-11-11");
        YzhResponse<GetDailyOrderFileV2Response> response = null;
        try {
            response = client.getDailyOrderFileV2(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetDailyOrderFileV2Response data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void listDailyBill() {
        ListDailyBillRequest request = new ListDailyBillRequest();
        request.setBillDate("2020-03-25");
        request.setOffset(0);
        request.setLength(200);
        request.setDataType("encryption");
        YzhResponse<ListDailyBillResponse> response = null;
        try {
            response = client.listDailyBill(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ListDailyBillResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\u8fd4\u56de\u6761\u6570\uff1a" + data.getTotalNum());
                for (DealerBillInfo bill : data.getList()) {
                    System.out.println("---------");
                    System.out.println(bill);
                }
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void listBalanceDailyStatement() {
        ListBalanceDailyStatementRequest request = new ListBalanceDailyStatementRequest();
        request.setStatementDate("2021-03-25");
        YzhResponse<ListBalanceDailyStatementResponse> response = null;
        try {
            response = client.listBalanceDailyStatement(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ListBalanceDailyStatementResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\u8fd4\u56de\u6761\u6570\uff1a" + data.getList().length);
                for (StatementDetail info : data.getList()) {
                    System.out.println("---------");
                    System.out.println(info);
                }
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void listDailyOrderSummary() {
        ListDailyOrderSummaryRequest request = new ListDailyOrderSummaryRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setChannel("\u652f\u4ed8\u5b9d");
        request.setBeginAt("2025-02-01");
        request.setEndAt("2025-02-07");
        request.setFilterType("apply");
        YzhResponse<ListDailyOrderSummaryResponse> response = null;
        try {
            response = client.listDailyOrderSummary(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ListDailyOrderSummaryResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\u8fd4\u56de\u6761\u6570\uff1a" + data.getSummaryList().length);
                for (ListDailyOrderSummary info : data.getSummaryList()) {
                    System.out.println(info);
                }
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void listMonthlyOrderSummary() {
        ListMonthlyOrderSummaryRequest request = new ListMonthlyOrderSummaryRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setChannel("\u94f6\u884c\u5361");
        request.setMonth("2025-01");
        request.setFilterType("apply");
        YzhResponse<ListMonthlyOrderSummaryResponse> response = null;
        try {
            response = client.listMonthlyOrderSummary(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ListMonthlyOrderSummaryResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

