/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.example;

import com.yunzhanghu.example.config.Config;
import com.yunzhanghu.example.utils.BaseUtil;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.invoice.InvoiceClient;
import com.yunzhanghu.sdk.invoice.domain.ApplyInvoiceRequest;
import com.yunzhanghu.sdk.invoice.domain.ApplyInvoiceResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceAmountRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceAmountResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceFileRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceFileResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceInformationRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceInformationResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceStatRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceStatResponse;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceStatusRequest;
import com.yunzhanghu.sdk.invoice.domain.GetInvoiceStatusResponse;
import com.yunzhanghu.sdk.invoice.domain.SendReminderEmailRequest;
import com.yunzhanghu.sdk.invoice.domain.SendReminderEmailResponse;

public class Invoice {
    private static YzhConfig config = Config.getYzhConfig();
    private static InvoiceClient client = new InvoiceClient(config);

    public static void main(String[] args) {
        Invoice.getInvoiceStat();
        Invoice.getInvoiceAmount();
        Invoice.applyInvoice();
        Invoice.getInvoiceStatus();
        Invoice.getInvoiceInformation();
        Invoice.getInvoiceFile();
        Invoice.sendReminderEmail();
    }

    private static void getInvoiceStat() {
        GetInvoiceStatRequest request = new GetInvoiceStatRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setYear(2023);
        YzhResponse<GetInvoiceStatResponse> response = null;
        try {
            response = client.getInvoiceStat(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetInvoiceStatResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getInvoiceAmount() {
        GetInvoiceAmountRequest request = new GetInvoiceAmountRequest();
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        YzhResponse<GetInvoiceAmountResponse> response = null;
        try {
            response = client.getInvoiceAmount(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetInvoiceAmountResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void applyInvoice() {
        String receiveEmail = "username1@example.com";
        String[] receiveEmails = new String[]{receiveEmail};
        ApplyInvoiceRequest request = new ApplyInvoiceRequest();
        request.setInvoiceApplyId("test1234567890");
        request.setDealerId(config.getDealerId());
        request.setBrokerId(config.getBrokerId());
        request.setAmount("1000000.00");
        request.setInvoiceType("1");
        request.setBankNameAccount("\u4ea4\u901a\u94f6\u884c\u5317\u4eac\u4e1c\u5927\u6865\u652f\u884c 12343456654321");
        request.setGoodsServicesName("\u4fe1\u606f\u6280\u672f\u670d\u52a1*\u4fe1\u606f\u6280\u672f\u670d\u52a1\u8d39");
        request.setRemark("\u6d4b\u8bd5\u5907\u6ce8");
        request.setReceiveEmails(receiveEmails);
        request.setInvoiceMedia("1");
        YzhResponse<ApplyInvoiceResponse> response = null;
        try {
            response = client.applyInvoice(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                ApplyInvoiceResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getInvoiceStatus() {
        GetInvoiceStatusRequest request = new GetInvoiceStatusRequest();
        request.setInvoiceApplyId("test1234567890");
        request.setApplicationId("a123b1110");
        YzhResponse<GetInvoiceStatusResponse> response = null;
        try {
            response = client.getInvoiceStatus(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetInvoiceStatusResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getInvoiceInformation() {
        GetInvoiceInformationRequest request = new GetInvoiceInformationRequest();
        request.setInvoiceApplyId("test1234567890");
        request.setApplicationId("a123b1110");
        YzhResponse<GetInvoiceInformationResponse> response = null;
        try {
            response = client.getInvoiceInformation(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetInvoiceInformationResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void getInvoiceFile() {
        GetInvoiceFileRequest request = new GetInvoiceFileRequest();
        request.setInvoiceApplyId("test1234567890");
        request.setApplicationId("a123b1110");
        YzhResponse<GetInvoiceFileResponse> response = null;
        try {
            response = client.getInvoiceFile(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                GetInvoiceFileResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sendReminderEmail() {
        SendReminderEmailRequest request = new SendReminderEmailRequest();
        request.setInvoiceApplyId("test1234567890");
        request.setApplicationId("a123b1110");
        YzhResponse<SendReminderEmailResponse> response = null;
        try {
            response = client.sendReminderEmail(YzhRequest.build(BaseUtil.getRandomStr("requestId"), request));
            if (response.isSuccess()) {
                SendReminderEmailResponse data = response.getData();
                System.out.println("\u64cd\u4f5c\u6210\u529f\uff1a" + data);
            } else {
                System.out.println("HTTP Status Code\uff1a" + response.getHttpCode());
                System.out.println("\u5931\u8d25\u8fd4\u56de\uff1a" + response.getCode() + response.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

