/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.base;

import com.google.gson.reflect.TypeToken;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.base.YzhRsaSign;
import com.yunzhanghu.sdk.base.YzhSha256Sign;
import com.yunzhanghu.sdk.base.YzhSign;
import com.yunzhanghu.sdk.utils.JsonUtil;
import com.yunzhanghu.sdk.utils.StringUtils;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YzhClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(YzhClient.class);
    private YzhSign yzhSign;
    private YzhConfig yzhConfig;
    private int socketTimeout;

    public YzhClient(YzhConfig yzhConfig) {
        this.setYzhConfig(yzhConfig);
        if (YzhConfig.SignType.RSA.equals((Object)yzhConfig.getSignType())) {
            this.setYzhSign(new YzhRsaSign(yzhConfig));
        }
        if (YzhConfig.SignType.SHA256.equals((Object)yzhConfig.getSignType())) {
            this.setYzhSign(new YzhSha256Sign(yzhConfig));
        }
    }

    private static <T> YzhResponse<T> fromJsonResult(String data, Type t) {
        return (YzhResponse)JsonUtil.fromLowerCasesWithUnderScoresJson(data, t);
    }

    protected YzhSign.SignedData sign(Object request) throws Exception {
        return this.yzhSign.sign(request);
    }

    public YzhSign getYzhSign() {
        return this.yzhSign;
    }

    public void setYzhSign(YzhSign yzhSign) {
        this.yzhSign = yzhSign;
    }

    public YzhConfig getYzhConfig() {
        return this.yzhConfig;
    }

    public void setYzhConfig(YzhConfig yzhConfig) {
        this.yzhConfig = yzhConfig;
    }

    public int getSocketTimeout() {
        return this.socketTimeout == 0 ? 30000 : this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public <K, T> YzhResponse<T> post(YzhRequest<K> yzhRequest, String url, TypeToken<YzhResponse<T>> typeToken) throws Exception {
        return this.postMethod(yzhRequest, this.getYzhConfig().getYzhUrl() + url, typeToken);
    }

    private <K, T> YzhResponse<T> postMethod(YzhRequest<K> yzhRequest, String url, TypeToken<YzhResponse<T>> typeToken) throws Exception {
        YzhResponse<T> response;
        YzhSign.SignedData signedData = this.sign(yzhRequest.getRequest());
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(this.getSocketTimeout()).build();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setDefaultRequestConfig(config).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
        httpPost.setHeader("dealer-id", this.yzhConfig.getDealerId());
        httpPost.setHeader("request-id", yzhRequest.getRequestId());
        httpPost.setHeader("User-Agent", StringUtils.getUA());
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("mess", signedData.getMess()));
        params.add(new BasicNameValuePair("timestamp", String.valueOf(signedData.getTimestamp())));
        params.add(new BasicNameValuePair("sign_type", signedData.getSignType()));
        params.add(new BasicNameValuePair("data", signedData.getData()));
        params.add(new BasicNameValuePair("sign", signedData.getSign()));
        CloseableHttpResponse httpResponse = null;
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String result = this.getResponse((HttpRequestBase)httpPost, httpResponse, statusCode);
            response = (YzhResponse<T>)JsonUtil.fromLowerCasesWithUnderScoresJson(result, YzhResponse.class);
            response = YzhClient.fromJsonResult(result, typeToken.getType());
            response.setHttpCode(statusCode);
        }
        catch (Exception e) {
            LOGGER.error("postMethod exception", (Throwable)e);
            throw e;
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException io) {
                    LOGGER.error("httpResponse.close error", (Throwable)io);
                }
            }
        }
        return response;
    }

    public <K, T> YzhResponse<T> get(YzhRequest<K> yzhRequest, String url, boolean isEncrypt, TypeToken<YzhResponse<T>> typeToken) throws Exception {
        YzhSign.SignedData signedData = this.sign(yzhRequest.getRequest());
        return this.getMethod(this.getYzhConfig().getYzhUrl() + url + "?" + signedData.getPlainEncode(), yzhRequest, isEncrypt, typeToken);
    }

    private <K, T> YzhResponse<T> getMethod(String url, YzhRequest<K> yzhRequest, boolean isEncrypt, TypeToken<YzhResponse<T>> typeToken) throws Exception {
        YzhResponse response;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(this.getSocketTimeout()).build();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setDefaultRequestConfig(config).build();
        HttpGet httpget = new HttpGet(url);
        httpget.setHeader("Content-Type", "application/x-www-form-urlencoded");
        httpget.setHeader("dealer-id", this.yzhConfig.getDealerId());
        httpget.setHeader("request-id", yzhRequest.getRequestId());
        CloseableHttpResponse httpResponse = null;
        try {
            Map map;
            Object data;
            httpResponse = httpClient.execute((HttpUriRequest)httpget);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            String result = this.getResponse((HttpRequestBase)httpget, httpResponse, statusCode);
            response = (YzhResponse)JsonUtil.fromLowerCasesWithUnderScoresJson(result, YzhResponse.class);
            if (!"0000".equals(response.getCode())) {
                response.setHttpCode(statusCode);
                response.setData(null);
                YzhResponse yzhResponse = response;
                return yzhResponse;
            }
            if (isEncrypt && null != (data = (map = (Map)JsonUtil.fromLowerCasesWithUnderScoresJson(result, new TypeToken<Map<String, String>>(){}.getType())).get("data"))) {
                String dataStr = this.getYzhSign().decrypt(data.toString());
                response = new YzhResponse();
                Object bizData = JsonUtil.fromLowerCasesWithUnderScoresJson(dataStr, this.getResponseType(typeToken));
                response.setData(bizData);
                response.setCode(StringUtils.trim(map.get("code")));
                response.setMessage(StringUtils.trim(map.get("message")));
                response.setRequestId(StringUtils.trim(map.get("requestId")));
                if (StringUtils.isNull(response.getRequestId())) {
                    response.setRequestId(StringUtils.trim(map.get("requestID")));
                }
                response.setHttpCode(statusCode);
                YzhResponse yzhResponse = response;
                return yzhResponse;
            }
            response = YzhClient.fromJsonResult(result, typeToken.getType());
            response.setHttpCode(statusCode);
        }
        catch (Exception e) {
            LOGGER.error("getMethod exception", (Throwable)e);
            throw e;
        }
        finally {
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException io) {
                    LOGGER.error("httpResponse.close error", (Throwable)io);
                }
            }
        }
        return response;
    }

    public <T> Type getResponseType(TypeToken<YzhResponse<T>> typeToken) {
        ParameterizedType parameterizedType = (ParameterizedType)typeToken.getType();
        return parameterizedType.getActualTypeArguments()[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getResponse(HttpRequestBase httpRequest, CloseableHttpResponse httpResponse, int statusCode) throws IOException {
        String result = "";
        if (statusCode != 200) {
            if (statusCode == 302) {
                return httpResponse.getHeaders("location")[0].getValue();
            }
            httpRequest.abort();
            throw new RuntimeException("HttpClient,error status code :" + statusCode);
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        EntityUtils.consume((HttpEntity)entity);
        return result;
    }

    public void handleError(YzhRequest<?> req, Exception e) {
        if (this.yzhConfig.isDebug()) {
            LOGGER.error("request: {}, errorMsg: {}", new Object[]{req, e.getMessage(), e});
        }
    }
}

