/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.base;

import com.yunzhanghu.sdk.YzhException;
import com.yunzhanghu.sdk.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class YzhConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(YzhConfig.class);
    public static String YZH = "yzh";
    public static String YZH_PRE = "yzh.";
    public static String YZH_URL = "url";
    public static String YZH_SIGN_TYPE = "sign_type";
    public static String YZH_DEALER_ID = "dealer_id";
    public static String YZH_BROKER_ID = "broker_id";
    public static String YZH_3DES_KEY = "3des_key";
    public static String YZH_APP_KEY = "app_key";
    public static String YZH_RSA_PRIVATE_KEY = "rsa_private_key";
    public static String YZH_RSA_PUBLIC_KEY = "rsa_public_key";
    public static String YZH_IS_DEBUG = "is_debug";
    private SignType signType;
    private String dealerId;
    private String brokerId;
    private String yzh3DesKey;
    private String yzhAppKey;
    private String yzhRsaPublicKey;
    private String yzhRsaPrivateKey;
    private String yzhUrl;
    private boolean isDebug;

    public static YzhConfig loadConfig(String fileName) throws Exception {
        if ((fileName = StringUtils.trim(fileName)).endsWith("yaml") || fileName.endsWith("yml")) {
            return YzhConfig.loadYaml(fileName);
        }
        return YzhConfig.loadProperties(fileName);
    }

    public static YzhConfig loadProperties(String fileName) throws Exception {
        InputStream inputStream = null;
        YzhConfig config = new YzhConfig();
        try {
            inputStream = YzhConfig.class.getClassLoader().getResourceAsStream(fileName);
            if (inputStream == null) {
                throw new FileNotFoundException("property file '" + fileName + "' not found in the classpath");
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            SignType signType = SignType.valueOf(properties.getProperty(YZH_PRE + YZH_SIGN_TYPE).toUpperCase());
            config.setSignType(signType);
            config.setYzh3DesKey(properties.getProperty(YZH_PRE + YZH_3DES_KEY));
            config.setDealerId(properties.getProperty(YZH_PRE + YZH_DEALER_ID));
            config.setBrokerId(properties.getProperty(YZH_PRE + YZH_BROKER_ID));
            config.setYzhAppKey(properties.getProperty(YZH_PRE + YZH_APP_KEY));
            config.setYzhRsaPrivateKey(properties.getProperty(YZH_PRE + YZH_RSA_PRIVATE_KEY));
            config.setYzhRsaPublicKey(properties.getProperty(YZH_PRE + YZH_RSA_PUBLIC_KEY));
            config.setYzhUrl(properties.getProperty(YZH_PRE + YZH_URL));
            config.setIsDebug(true);
            String isDebugStr = properties.getProperty(YZH_PRE + YZH_IS_DEBUG);
            if ("false".equalsIgnoreCase(isDebugStr)) {
                config.setIsDebug(false);
            }
            config.checkConfig();
        }
        catch (Exception e) {
            LOGGER.error("LoadConfig error", (Throwable)e);
            throw e;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException io) {
                    LOGGER.error("inputStream close error", (Throwable)io);
                }
            }
        }
        return config;
    }

    public static YzhConfig loadYaml(String fileName) throws Exception {
        YzhConfig config;
        block14: {
            InputStream inputStream = null;
            config = new YzhConfig();
            try {
                inputStream = YzhConfig.class.getClassLoader().getResourceAsStream(fileName);
                if (inputStream == null) {
                    throw new FileNotFoundException("yaml file '" + fileName + "' not found in the classpath");
                }
                Yaml yaml = new Yaml();
                Map map = (Map)yaml.load(inputStream);
                if (map.get(YZH) != null) {
                    Map properties = (Map)map.get(YZH);
                    SignType signType = SignType.valueOf(StringUtils.trim(properties.get(YZH_SIGN_TYPE)).toUpperCase());
                    config.setSignType(signType);
                    config.setYzh3DesKey(StringUtils.trim(properties.get(YZH_3DES_KEY)));
                    config.setDealerId(StringUtils.trim(properties.get(YZH_DEALER_ID)));
                    config.setBrokerId(StringUtils.trim(properties.get(YZH_BROKER_ID)));
                    config.setYzhAppKey(StringUtils.trim(properties.get(YZH_APP_KEY)));
                    config.setYzhRsaPrivateKey(StringUtils.trim(properties.get(YZH_RSA_PRIVATE_KEY)));
                    config.setYzhRsaPublicKey(StringUtils.trim(properties.get(YZH_RSA_PUBLIC_KEY)));
                    config.setYzhUrl(StringUtils.trim(properties.get(YZH_URL)));
                    config.setIsDebug(true);
                    String isDebugStr = StringUtils.trim(properties.get(YZH_IS_DEBUG));
                    if ("false".equalsIgnoreCase(isDebugStr)) {
                        config.setIsDebug(false);
                    }
                    config.checkConfig();
                    break block14;
                }
                throw new YzhException("key yzh not found in config file");
            }
            catch (ClassCastException cce) {
                LOGGER.error("LoadConfig error", (Throwable)cce);
                throw new YzhException("yzh config is illegal");
            }
            catch (Exception e) {
                LOGGER.error("LoadConfig error", (Throwable)e);
                throw e;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException io) {
                        LOGGER.error("inputStream close error", (Throwable)io);
                    }
                }
            }
        }
        return config;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public String getYzhUrl() {
        return this.yzhUrl;
    }

    public void setYzhUrl(String yzhUrl) {
        this.yzhUrl = yzhUrl;
    }

    public SignType getSignType() {
        return this.signType;
    }

    public void setSignType(SignType signType) {
        this.signType = signType;
    }

    public String getYzh3DesKey() {
        return this.yzh3DesKey;
    }

    public void setYzh3DesKey(String yzh3DesKey) {
        this.yzh3DesKey = yzh3DesKey;
    }

    public String getYzhAppKey() {
        return this.yzhAppKey;
    }

    public void setYzhAppKey(String yzhAppKey) {
        this.yzhAppKey = yzhAppKey;
    }

    public String getYzhRsaPublicKey() {
        return this.yzhRsaPublicKey;
    }

    public void setYzhRsaPublicKey(String yzhRsaPublicKey) {
        this.yzhRsaPublicKey = yzhRsaPublicKey.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replace("\r\n", "").replace("\r", "").replace("\n", "").replaceAll("\\s*", "");
    }

    public String getYzhRsaPrivateKey() {
        return this.yzhRsaPrivateKey;
    }

    public void setYzhRsaPrivateKey(String yzhRsaPrivateKey) {
        this.yzhRsaPrivateKey = yzhRsaPrivateKey.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\r\n", "").replace("\r", "").replace("\n", "").replaceAll("\\s*", "");
    }

    public String getDealerId() {
        return this.dealerId;
    }

    public void setDealerId(String dealerId) {
        this.dealerId = dealerId;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }

    private void checkConfig() throws YzhException {
        if (StringUtils.isNull(this.getDealerId())) {
            throw new YzhException("dealer_id is empty");
        }
        if (StringUtils.isNull(this.getYzhUrl())) {
            throw new YzhException("url is empty");
        }
        if (StringUtils.isNull(this.getYzhAppKey())) {
            throw new YzhException("app_key is empty");
        }
        if (SignType.SHA256.equals((Object)this.getSignType()) && StringUtils.isNull(this.getYzh3DesKey())) {
            throw new YzhException("3des_key is empty");
        }
        if (SignType.RSA.equals((Object)this.getSignType())) {
            if (StringUtils.isNull(this.getYzhRsaPrivateKey())) {
                throw new YzhException("rsa.private.key is empty");
            }
            if (StringUtils.isNull(this.getYzhRsaPublicKey())) {
                throw new YzhException("rsa.public.key is empty");
            }
        }
    }

    public String toString() {
        return "YzhConfig{dealerId=" + this.dealerId + ", brokerId=" + this.brokerId + ", signType=" + (Object)((Object)this.signType) + ", yzh3DesKey='" + this.yzh3DesKey + '\'' + ", yzhAppKey='" + this.yzhAppKey + '\'' + ", yzhRsaPublicKey='" + this.yzhRsaPublicKey + '\'' + ", yzhRsaPrivateKey='" + this.yzhRsaPrivateKey + '\'' + ", yzhUrl='" + this.yzhUrl + '\'' + "}";
    }

    public static enum SignType {
        RSA("rsa"),
        SHA256("sha256");

        private final String value;

        private SignType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

