/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.base;

import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.utils.DESUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

public abstract class YzhSign {
    private YzhConfig yzhConfig;

    public YzhSign(YzhConfig yzhConfig) {
        this.setYzhConfig(yzhConfig);
    }

    protected SignedData sign(Object request) throws Exception {
        SignedData signedData = new SignedData();
        signedData.setSignType(this.getYzhConfig().getSignType().getValue());
        signedData.setMess(ThreadLocalRandom.current().nextInt(1000) + "");
        signedData.setTimestamp(Integer.parseInt(String.valueOf(System.currentTimeMillis() / 1000L)));
        signedData.setData(this.encData(request));
        String plain = "data=" + signedData.getData() + "&mess=" + signedData.getMess() + "&timestamp=" + signedData.getTimestamp() + "&key=" + this.getYzhConfig().getYzhAppKey();
        signedData.setSign(this.sign(plain));
        return signedData;
    }

    protected abstract String sign(String var1) throws Exception;

    protected abstract String encData(Object var1) throws Exception;

    public String decrypt(String data) throws Exception {
        return DESUtil.decode(this.yzhConfig.getYzh3DesKey(), data, StandardCharsets.UTF_8);
    }

    public YzhConfig getYzhConfig() {
        return this.yzhConfig;
    }

    public void setYzhConfig(YzhConfig yzhConfig) {
        this.yzhConfig = yzhConfig;
    }

    public class SignedData {
        private int timestamp;
        private String sign;
        private String signType;
        private String mess;
        private String data;

        public int getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public String getSignType() {
            return this.signType;
        }

        public void setSignType(String signType) {
            this.signType = signType;
        }

        public String getMess() {
            return this.mess;
        }

        public void setMess(String mess) {
            this.mess = mess;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        public String getSign() {
            return this.sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getPlainEncode() throws Exception {
            return "data=" + this.getEncode(this.data) + "&mess=" + this.getEncode(this.mess) + "&timestamp=" + this.timestamp + "&sign_type=" + this.getEncode(this.signType) + "&sign=" + this.getEncode(this.getSign());
        }

        private String getEncode(String content) throws Exception {
            return URLEncoder.encode(content, "UTF-8");
        }
    }
}

