/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.notify;

import com.yunzhanghu.sdk.base.YzhClient;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.notify.domain.NotifyRequest;
import com.yunzhanghu.sdk.notify.domain.NotifyResponse;
import com.yunzhanghu.sdk.utils.DESUtil;
import com.yunzhanghu.sdk.utils.JsonUtil;
import com.yunzhanghu.sdk.utils.RSAUtil;
import com.yunzhanghu.sdk.utils.Sha256Util;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyClient
extends YzhClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotifyClient.class);
    private static Charset charset = StandardCharsets.UTF_8;

    public NotifyClient(YzhConfig yzhConfig) {
        super(yzhConfig);
    }

    public <T> NotifyResponse<T> notifyDecoder(NotifyRequest request, Class<?> clazz) {
        NotifyResponse response = new NotifyResponse();
        if (YzhConfig.SignType.RSA.equals((Object)this.getYzhConfig().getSignType())) {
            response = this.verifyAndDescryptRSA(request, clazz);
        } else if (YzhConfig.SignType.SHA256.equals((Object)this.getYzhConfig().getSignType())) {
            response = this.verifyAndDescryptSha256(request, clazz);
        } else {
            throw new RuntimeException("signType error! signType must be rsa or sha256!");
        }
        return response;
    }

    private <T> NotifyResponse<T> verifyAndDescryptRSA(NotifyRequest request, Class<?> clazz) {
        NotifyResponse response = new NotifyResponse();
        if (!this.verifyRSA(request).booleanValue()) {
            response.setSignRes(false);
            return response;
        }
        response.setSignRes(true);
        String descryptRes = this.descrypt3DES(request.getData());
        if (descryptRes == null) {
            response.setDescryptRes(false);
            return response;
        }
        response.setDescryptRes(true);
        response.setData(JsonUtil.fromLowerCasesWithUnderScoresJson(descryptRes, clazz));
        return response;
    }

    private <T> NotifyResponse<T> verifyAndDescryptSha256(NotifyRequest request, Class<?> clazz) {
        NotifyResponse response = new NotifyResponse();
        if (!this.verifySha256(request).booleanValue()) {
            response.setSignRes(false);
            return response;
        }
        response.setSignRes(true);
        String descryptRes = this.descrypt3DES(request.getData());
        if (descryptRes == null) {
            response.setDescryptRes(false);
            return response;
        }
        response.setDescryptRes(true);
        response.setData(JsonUtil.fromLowerCasesWithUnderScoresJson(descryptRes, clazz));
        return response;
    }

    private Boolean verifySha256(NotifyRequest request) {
        Boolean res = false;
        try {
            String content = this.getPain(request);
            res = Sha256Util.verify(content, request.getSign(), this.getYzhConfig().getYzhAppKey(), charset);
        }
        catch (Exception e) {
            LOGGER.error("Sha256 verify error, errorMsg: {}", (Object)e.getMessage(), (Object)e);
        }
        return res;
    }

    private Boolean verifyRSA(NotifyRequest request) {
        Boolean res = false;
        try {
            String content = this.getPain(request);
            res = RSAUtil.verify(content, request.getSign(), this.getYzhConfig().getYzhRsaPublicKey(), charset);
        }
        catch (Exception e) {
            LOGGER.error("RSA verify error, errorMsg: {}", (Object)e.getMessage(), (Object)e);
        }
        return res;
    }

    private String descrypt3DES(String data) {
        String res = null;
        try {
            res = DESUtil.decode(this.getYzhConfig().getYzh3DesKey(), data, charset);
        }
        catch (Exception e) {
            LOGGER.error("3DES descrypt error, errorMsg: {}", (Object)e.getMessage(), (Object)e);
        }
        return res;
    }

    private String getPain(NotifyRequest request) {
        String plain = "data=" + request.getData() + "&mess=" + request.getMess() + "&timestamp=" + request.getTimestamp() + "&key=" + this.getYzhConfig().getYzhAppKey();
        return plain;
    }
}

