/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.utils;

import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.utils.RSAUtil;
import com.yunzhanghu.sdk.utils.Sha256Util;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

public class CustomerLinkUtil {
    public static String getCustomerLink(YzhConfig config, String baseUrl, String memberId) {
        return CustomerLinkUtil.getLinkUrl(config, baseUrl, memberId);
    }

    private static String getLinkUrl(YzhConfig config, String baseUrl, String memberId) {
        try {
            String mess = ThreadLocalRandom.current().nextInt(1000) + "";
            String timestamp = Integer.parseInt(String.valueOf(System.currentTimeMillis() / 1000L)) + "";
            String sign = CustomerLinkUtil.signer(config, memberId, mess, timestamp);
            String url = baseUrl + "?sign_type=" + config.getSignType().getValue() + "&sign=" + URLEncoder.encode(sign, "UTF-8") + "&member_id=" + memberId + "&mess=" + mess + "&timestamp=" + timestamp;
            return url;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String signer(YzhConfig config, String memberId, String mess, String timestamp) {
        String sign;
        String plain = CustomerLinkUtil.getSignString(memberId, mess, timestamp, config.getYzhAppKey());
        if (YzhConfig.SignType.SHA256.equals((Object)config.getSignType())) {
            sign = Sha256Util.sign(plain, config.getYzhAppKey(), StandardCharsets.UTF_8);
        } else if (YzhConfig.SignType.RSA.equals((Object)config.getSignType())) {
            sign = RSAUtil.sign(plain, config.getYzhRsaPrivateKey(), StandardCharsets.UTF_8);
        } else {
            throw new RuntimeException("signType can't be null!");
        }
        return sign;
    }

    private static String getSignString(String memberId, String mess, String timestamp, String appKey) {
        String plain = "data=member_id=" + memberId + "&mess=" + mess + "&timestamp=" + timestamp + "&key=" + appKey;
        return plain;
    }
}

