/*
 * Decompiled with CFR 0.152.
 */
package com.yunzhanghu.sdk.yzhcustom;

import com.google.gson.reflect.TypeToken;
import com.yunzhanghu.sdk.YzhException;
import com.yunzhanghu.sdk.base.YzhClient;
import com.yunzhanghu.sdk.base.YzhConfig;
import com.yunzhanghu.sdk.base.YzhRequest;
import com.yunzhanghu.sdk.base.YzhResponse;
import com.yunzhanghu.sdk.utils.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YzhCustomClient
extends YzhClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(YzhCustomClient.class);

    public YzhCustomClient(YzhConfig yzhConfig) {
        super(yzhConfig);
    }

    public <K, T> YzhResponse<T> doRequest(YzhRequest<K> req, String url, String method, Class<T> clazz) throws YzhException {
        try {
            YzhResponse<T> response = new YzhResponse<T>();
            response = ClientMethodType.GET.getValue().equals(method.toUpperCase()) ? this.get(req, url, false, new TypeToken<YzhResponse<T>>(){}) : this.post(req, url, new TypeToken<YzhResponse<T>>(){});
            response.setData(this.linkTreeMapToEntry(response.getData(), clazz));
            return response;
        }
        catch (Exception e) {
            this.handleError(req, e);
            throw new YzhException("msg", e);
        }
    }

    private <K, T> T linkTreeMapToEntry(K data, Class<T> clazz) {
        String json = JsonUtil.toJson(data);
        return JsonUtil.fromLowerCasesWithUnderScoresJson(json, clazz);
    }

    public static enum ClientMethodType {
        POST("POST"),
        GET("GET");

        private final String value;

        private ClientMethodType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

