/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search.tavily;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.web.search.tavily.TavilyApi;
import dev.langchain4j.web.search.tavily.TavilyResponse;
import dev.langchain4j.web.search.tavily.TavilySearchRequest;
import java.io.IOException;
import java.time.Duration;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

class TavilyClient {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private final TavilyApi tavilyApi;

    public TavilyClient(String baseUrl, Duration timeout) {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(Utils.ensureTrailingForwardSlash((String)baseUrl)).client(okHttpClientBuilder.build()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)GSON)).build();
        this.tavilyApi = (TavilyApi)retrofit.create(TavilyApi.class);
    }

    public TavilyResponse search(TavilySearchRequest searchRequest) {
        try {
            Response retrofitResponse = this.tavilyApi.search(searchRequest).execute();
            if (retrofitResponse.isSuccessful()) {
                return (TavilyResponse)retrofitResponse.body();
            }
            throw TavilyClient.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RuntimeException toException(Response<?> response) throws IOException {
        int code = response.code();
        String body = response.errorBody().string();
        String errorMessage = String.format("status code: %s; body: %s", code, body);
        return new RuntimeException(errorMessage);
    }

    public static TavilyClientBuilder builder() {
        return new TavilyClientBuilder();
    }

    public static class TavilyClientBuilder {
        private String baseUrl;
        private Duration timeout;

        TavilyClientBuilder() {
        }

        public TavilyClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public TavilyClientBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public TavilyClient build() {
            return new TavilyClient(this.baseUrl, this.timeout);
        }

        public String toString() {
            return "TavilyClient.TavilyClientBuilder(baseUrl=" + this.baseUrl + ", timeout=" + this.timeout + ")";
        }
    }
}

