/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.Group;
import io.cucumber.cucumberexpressions.ParameterByTypeTransformer;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import io.cucumber.cucumberexpressions.TreeRegexp;
import io.cucumber.cucumberexpressions.UndefinedParameterTypeException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class CucumberExpression
implements Expression {
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([\\\\^\\[$.|?*+\\]])");
    static final Pattern PARAMETER_PATTERN = Pattern.compile("(\\\\\\\\)?\\{([^}]*)\\}");
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("(\\\\\\\\)?\\(([^)]+)\\)");
    private static final Pattern ALTERNATIVE_NON_WHITESPACE_TEXT_REGEXP = Pattern.compile("([^\\s^/]+)((/[^\\s^/]+)+)");
    private static final String DOUBLE_ESCAPE = "\\\\";
    private static final String PARAMETER_TYPES_CANNOT_BE_ALTERNATIVE = "Parameter types cannot be alternative: ";
    private static final String PARAMETER_TYPES_CANNOT_BE_OPTIONAL = "Parameter types cannot be optional: ";
    private final List<ParameterType<?>> parameterTypes = new ArrayList();
    private final String source;
    private final TreeRegexp treeRegexp;
    private final ParameterTypeRegistry parameterTypeRegistry;

    CucumberExpression(String expression, ParameterTypeRegistry parameterTypeRegistry) {
        this.source = expression;
        this.parameterTypeRegistry = parameterTypeRegistry;
        expression = this.processEscapes(expression);
        expression = this.processOptional(expression);
        expression = this.processAlternation(expression);
        expression = this.processParameters(expression, parameterTypeRegistry);
        expression = "^" + expression + "$";
        this.treeRegexp = new TreeRegexp(expression);
    }

    private String processEscapes(String expression) {
        return ESCAPE_PATTERN.matcher(expression).replaceAll("\\\\$1");
    }

    private String processAlternation(String expression) {
        Matcher matcher = ALTERNATIVE_NON_WHITESPACE_TEXT_REGEXP.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String replacement = matcher.group(0).replace('/', '|').replaceAll("\\\\\\|", "/");
            if (replacement.contains("|")) {
                for (String part : replacement.split("\\|")) {
                    this.checkNotParameterType(part, PARAMETER_TYPES_CANNOT_BE_ALTERNATIVE);
                }
                matcher.appendReplacement(sb, "(?:" + replacement + ")");
                continue;
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private void checkNotParameterType(String s, String message) {
        Matcher matcher = PARAMETER_PATTERN.matcher(s);
        if (matcher.find()) {
            throw new CucumberExpressionException(message + this.source);
        }
    }

    private String processOptional(String expression) {
        Matcher matcher = OPTIONAL_PATTERN.matcher(expression);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String parameterPart = matcher.group(2);
            if (DOUBLE_ESCAPE.equals(matcher.group(1))) {
                matcher.appendReplacement(sb, "\\\\(" + parameterPart + "\\\\)");
                continue;
            }
            this.checkNotParameterType(parameterPart, PARAMETER_TYPES_CANNOT_BE_OPTIONAL);
            matcher.appendReplacement(sb, "(?:" + parameterPart + ")?");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String processParameters(String expression, ParameterTypeRegistry parameterTypeRegistry) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = PARAMETER_PATTERN.matcher(expression);
        while (matcher.find()) {
            if (DOUBLE_ESCAPE.equals(matcher.group(1))) {
                matcher.appendReplacement(sb, "\\\\{" + matcher.group(2) + "\\\\}");
                continue;
            }
            String typeName = matcher.group(2);
            ParameterType.checkParameterTypeName(typeName);
            ParameterType parameterType = parameterTypeRegistry.lookupByTypeName(typeName);
            if (parameterType == null) {
                throw new UndefinedParameterTypeException(typeName);
            }
            this.parameterTypes.add(parameterType);
            matcher.appendReplacement(sb, Matcher.quoteReplacement(this.buildCaptureRegexp(parameterType.getRegexps())));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private String buildCaptureRegexp(List<String> regexps) {
        StringBuilder sb = new StringBuilder("(");
        if (regexps.size() == 1) {
            sb.append(regexps.get(0));
        } else {
            boolean bar = false;
            for (String captureGroupRegexp : regexps) {
                if (bar) {
                    sb.append("|");
                }
                sb.append("(?:").append(captureGroupRegexp).append(")");
                bar = true;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public List<Argument<?>> match(String text, Type ... typeHints) {
        Group group = this.treeRegexp.match(text);
        if (group == null) {
            return null;
        }
        ArrayList parameterTypes = new ArrayList(this.parameterTypes);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            Class<String> type;
            ParameterType parameterType = (ParameterType)parameterTypes.get(i);
            Class<String> clazz = type = i < typeHints.length ? typeHints[i] : String.class;
            if (!parameterType.isAnonymous()) continue;
            ParameterByTypeTransformer defaultTransformer = this.parameterTypeRegistry.getDefaultParameterTransformer();
            parameterTypes.set(i, parameterType.deAnonymize((Type)((Object)type), arg -> defaultTransformer.transform(arg, (Type)((Object)type))));
        }
        return Argument.build(group, this.treeRegexp, parameterTypes);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public Pattern getRegexp() {
        return this.treeRegexp.pattern();
    }
}

