/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.spi;

import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import io.debezium.util.Collect;
import java.util.Set;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public abstract class RecordParser {
    private final Struct record;
    private final String id;
    private final String type;
    private final Struct source;
    private final Struct transaction;
    private final String op;
    private final Schema opSchema;
    private final String ts_ms;
    private final Schema ts_msSchema;
    private final Schema dataSchema;
    private final String connectorType;
    protected static final Set<String> SOURCE_FIELDS = Collect.unmodifiableSet("version", "connector", "name", "ts_ms", "snapshot", "db");

    protected RecordParser(RecordAndMetadata recordAndMetadata, String ... dataFields) {
        this.record = recordAndMetadata.record();
        this.id = recordAndMetadata.id();
        this.type = recordAndMetadata.type();
        this.source = recordAndMetadata.source();
        this.transaction = recordAndMetadata.transaction();
        this.op = recordAndMetadata.operation();
        this.opSchema = Schema.STRING_SCHEMA;
        this.ts_ms = (String)recordAndMetadata.timestamp().value();
        this.ts_msSchema = recordAndMetadata.timestamp().schema();
        this.connectorType = this.source.getString("connector");
        this.dataSchema = recordAndMetadata.dataSchema(dataFields);
    }

    public String id() {
        return this.id;
    }

    public String type() {
        return this.type;
    }

    public Struct source() {
        return this.source;
    }

    public Struct transaction() {
        return this.transaction;
    }

    public String op() {
        return this.op;
    }

    public Schema opSchema() {
        return this.opSchema;
    }

    public String ts_ms() {
        return this.ts_ms;
    }

    public Schema ts_msSchema() {
        return this.ts_msSchema;
    }

    public Schema dataSchema() {
        return this.dataSchema;
    }

    public Struct data() {
        Struct data = new Struct(this.dataSchema());
        for (Field field : this.dataSchema.fields()) {
            data.put(field, this.record.get(field));
        }
        return data;
    }

    public String connectorType() {
        return this.connectorType;
    }

    public abstract Object getMetadata(String var1);
}

