/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.spi.SnapshotLock;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class SnapshotLockProvider
implements ServiceProvider<SnapshotLock> {
    @Override
    public SnapshotLock createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        BeanRegistry beanRegistry = serviceRegistry.tryGetService(BeanRegistry.class);
        CommonConnectorConfig commonConnectorConfig = beanRegistry.lookupByName("ConnectorConfig", CommonConnectorConfig.class);
        String configuredSnapshotLockingMode = this.snapshotLockingMode(commonConnectorConfig);
        String snapshotLockingModeCustomName = commonConnectorConfig.snapshotLockingModeCustomName();
        String snapshotLockMode = "custom".equals(configuredSnapshotLockingMode) && !snapshotLockingModeCustomName.isEmpty() ? snapshotLockingModeCustomName : configuredSnapshotLockingMode;
        Optional<SnapshotLock> snapshotLock = StreamSupport.stream(ServiceLoader.load(SnapshotLock.class).spliterator(), false).filter(s -> s.name().equalsIgnoreCase(snapshotLockMode)).findAny();
        return snapshotLock.map(s -> {
            s.configure(configuration.asMap());
            if (s instanceof BeanRegistryAware) {
                ((BeanRegistryAware)((Object)s)).injectBeanRegistry(beanRegistry);
            }
            return s;
        }).orElseThrow(() -> new DebeziumException(String.format("Unable to find %s snapshot lock mode. Please check your configuration.", snapshotLockMode)));
    }

    @Override
    public Class<SnapshotLock> getServiceClass() {
        return SnapshotLock.class;
    }

    public String snapshotLockingMode(CommonConnectorConfig configuration) {
        if (configuration.getSnapshotLockingMode().isEmpty()) {
            return "no_locking_support";
        }
        return configuration.getSnapshotLockingMode().get().getValue();
    }
}

