/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.document.DocumentReader;
import io.debezium.document.DocumentWriter;
import io.debezium.relational.history.AbstractSchemaHistory;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.SchemaHistoryException;
import io.debezium.util.FunctionalReadWriteLock;
import io.debezium.util.Loggings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileBasedSchemaHistory
extends AbstractSchemaHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFileBasedSchemaHistory.class);
    protected final FunctionalReadWriteLock lock = FunctionalReadWriteLock.reentrant();
    protected final AtomicBoolean running = new AtomicBoolean();
    protected final DocumentWriter documentWriter = DocumentWriter.defaultWriter();
    protected final DocumentReader documentReader = DocumentReader.defaultReader();
    protected volatile List<HistoryRecord> records = new ArrayList<HistoryRecord>();

    protected void toHistoryRecord(InputStream inputStream) {
        try (BufferedReader historyReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = historyReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                this.records.add(new HistoryRecord(this.documentReader.read(line)));
            }
        }
        catch (IOException e) {
            throw new SchemaHistoryException("Unable to read object content", e);
        }
    }

    protected byte[] fromHistoryRecord(HistoryRecord record) {
        LOGGER.trace("Storing record into database history: {}", (Object)record);
        this.records.add(record);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (BufferedWriter historyWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));){
            for (HistoryRecord r : this.records) {
                String line = this.documentWriter.write(r.document());
                if (line == null) continue;
                historyWriter.newLine();
                historyWriter.append(line);
            }
        }
        catch (IOException e) {
            Loggings.logErrorAndTraceRecord(this.logger, (Object)record, "Failed to convert record", e);
            throw new SchemaHistoryException("Failed to convert record", e);
        }
        return outputStream.toByteArray();
    }

    protected List<HistoryRecord> getRecords() {
        return this.records;
    }

    @Override
    public synchronized void start() {
        this.doPreStart();
        this.lock.write(() -> {
            if (this.running.compareAndSet(false, true)) {
                if (!this.storageExists()) {
                    this.initializeStorage();
                }
                this.doStart();
            }
        });
        super.start();
    }

    @Override
    public synchronized void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.doStop();
        }
        super.stop();
    }

    @Override
    protected void storeRecord(HistoryRecord record) throws SchemaHistoryException {
        this.doPreStoreRecord(record);
        if (record == null) {
            return;
        }
        this.lock.write(() -> {
            if (!this.running.get()) {
                throw new SchemaHistoryException("The history has been stopped and will not accept more records");
            }
            this.doStoreRecord(record);
        });
    }

    @Override
    protected void recoverRecords(Consumer<HistoryRecord> records) {
        this.lock.write(() -> this.getRecords().forEach(records));
    }

    @Override
    public boolean exists() {
        return !this.getRecords().isEmpty();
    }

    protected void doPreStart() {
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doPreStoreRecord(HistoryRecord record) {
    }

    protected void doStoreRecord(HistoryRecord record) {
    }
}

