/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRef;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCBackendRefFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilterBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilterFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GRPCBackendRefFluentImpl<A extends GRPCBackendRefFluent<A>>
extends BaseFluent<A>
implements GRPCBackendRefFluent<A> {
    private ArrayList<GRPCRouteFilterBuilder> filters = new ArrayList();
    private String group;
    private String kind;
    private String name;
    private String namespace;
    private Integer port;
    private Integer weight;
    private Map<String, Object> additionalProperties;

    public GRPCBackendRefFluentImpl() {
    }

    public GRPCBackendRefFluentImpl(GRPCBackendRef instance) {
        this.withFilters(instance.getFilters());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withPort(instance.getPort());
        this.withWeight(instance.getWeight());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToFilters(Integer index, GRPCRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
        this._visitables.get((Object)"filters").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"filters").size(), builder);
        this.filters.add(index >= 0 ? index.intValue() : this.filters.size(), builder);
        return (A)this;
    }

    @Override
    public A setToFilters(Integer index, GRPCRouteFilter item) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"filters").size()) {
            this._visitables.get((Object)"filters").add(builder);
        } else {
            this._visitables.get((Object)"filters").set(index, builder);
        }
        if (index < 0 || index >= this.filters.size()) {
            this.filters.add(builder);
        } else {
            this.filters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToFilters(GRPCRouteFilter ... items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToFilters(Collection<GRPCRouteFilter> items) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").add(builder);
            this.filters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromFilters(GRPCRouteFilter ... items) {
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").remove(builder);
            if (this.filters == null) continue;
            this.filters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFilters(Collection<GRPCRouteFilter> items) {
        for (GRPCRouteFilter item : items) {
            GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
            this._visitables.get((Object)"filters").remove(builder);
            if (this.filters == null) continue;
            this.filters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromFilters(Predicate<GRPCRouteFilterBuilder> predicate) {
        if (this.filters == null) {
            return (A)this;
        }
        Iterator<GRPCRouteFilterBuilder> each = this.filters.iterator();
        List visitables = this._visitables.get((Object)"filters");
        while (each.hasNext()) {
            GRPCRouteFilterBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GRPCRouteFilter> getFilters() {
        return this.filters != null ? GRPCBackendRefFluentImpl.build(this.filters) : null;
    }

    @Override
    public List<GRPCRouteFilter> buildFilters() {
        return this.filters != null ? GRPCBackendRefFluentImpl.build(this.filters) : null;
    }

    @Override
    public GRPCRouteFilter buildFilter(Integer index) {
        return this.filters.get(index).build();
    }

    @Override
    public GRPCRouteFilter buildFirstFilter() {
        return this.filters.get(0).build();
    }

    @Override
    public GRPCRouteFilter buildLastFilter() {
        return this.filters.get(this.filters.size() - 1).build();
    }

    @Override
    public GRPCRouteFilter buildMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        for (GRPCRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        for (GRPCRouteFilterBuilder item : this.filters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFilters(List<GRPCRouteFilter> filters) {
        if (this.filters != null) {
            this._visitables.get((Object)"filters").removeAll(this.filters);
        }
        if (filters != null) {
            this.filters = new ArrayList();
            for (GRPCRouteFilter item : filters) {
                this.addToFilters(item);
            }
        } else {
            this.filters = null;
        }
        return (A)this;
    }

    @Override
    public A withFilters(GRPCRouteFilter ... filters) {
        if (this.filters != null) {
            this.filters.clear();
        }
        if (filters != null) {
            for (GRPCRouteFilter item : filters) {
                this.addToFilters(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    @Override
    public GRPCBackendRefFluent.FiltersNested<A> addNewFilter() {
        return new FiltersNestedImpl();
    }

    @Override
    public GRPCBackendRefFluent.FiltersNested<A> addNewFilterLike(GRPCRouteFilter item) {
        return new FiltersNestedImpl(-1, item);
    }

    @Override
    public GRPCBackendRefFluent.FiltersNested<A> setNewFilterLike(Integer index, GRPCRouteFilter item) {
        return new FiltersNestedImpl(index, item);
    }

    @Override
    public GRPCBackendRefFluent.FiltersNested<A> editFilter(Integer index) {
        if (this.filters.size() <= index) {
            throw new RuntimeException("Can't edit filters. Index exceeds size.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public GRPCBackendRefFluent.FiltersNested<A> editFirstFilter() {
        if (this.filters.size() == 0) {
            throw new RuntimeException("Can't edit first filters. The list is empty.");
        }
        return this.setNewFilterLike(0, this.buildFilter(0));
    }

    @Override
    public GRPCBackendRefFluent.FiltersNested<A> editLastFilter() {
        int index = this.filters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last filters. The list is empty.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public GRPCBackendRefFluent.FiltersNested<A> editMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.filters.size(); ++i) {
            if (!predicate.test(this.filters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching filters. No match found.");
        }
        return this.setNewFilterLike(index, this.buildFilter(index));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    @Override
    public A withWeight(Integer weight) {
        this.weight = weight;
        return (A)this;
    }

    @Override
    public Boolean hasWeight() {
        return this.weight != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GRPCBackendRefFluentImpl that = (GRPCBackendRefFluentImpl)o;
        if (this.filters != null ? !this.filters.equals(that.filters) : that.filters != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.weight != null ? !this.weight.equals(that.weight) : that.weight != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.filters, this.group, this.kind, this.name, this.namespace, this.port, this.weight, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters != null && !this.filters.isEmpty()) {
            sb.append("filters:");
            sb.append(this.filters + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class FiltersNestedImpl<N>
    extends GRPCRouteFilterFluentImpl<GRPCBackendRefFluent.FiltersNested<N>>
    implements GRPCBackendRefFluent.FiltersNested<N>,
    Nested<N> {
        GRPCRouteFilterBuilder builder;
        Integer index;

        FiltersNestedImpl(Integer index, GRPCRouteFilter item) {
            this.index = index;
            this.builder = new GRPCRouteFilterBuilder(this, item);
        }

        FiltersNestedImpl() {
            this.index = -1;
            this.builder = new GRPCRouteFilterBuilder(this);
        }

        @Override
        public N and() {
            return (N)GRPCBackendRefFluentImpl.this.setToFilters(this.index, this.builder.build());
        }

        @Override
        public N endFilter() {
            return this.and();
        }
    }
}

