/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.Config;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdmServer {
    private static final String SESSION = "/session";
    private static final String GET = "GET";
    private static final String DELETE = "DELETE";
    private static final String POST = "POST";
    private static final String SESSIONID = "\"sessionId\":";
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Map<String, URL> sessionMap = new ConcurrentHashMap<String, URL>();
    private Map<String, WebDriverManager> wdmMap = new ConcurrentHashMap<String, WebDriverManager>();
    private Config config = new Config();
    private String path;

    public WdmServer(int port) {
        String serverPath = this.config.getServerPath();
        this.path = serverPath.endsWith("/") ? serverPath.substring(0, serverPath.length() - 1) : serverPath;
        Javalin app = Javalin.create().start(port);
        Handler handler = this::handleRequest;
        app.get(this.path + "/chromedriver", handler);
        app.get(this.path + "/firefoxdriver", handler);
        app.get(this.path + "/edgedriver", handler);
        app.get(this.path + "/iedriver", handler);
        app.get(this.path + "/operadriver", handler);
        app.post(this.path + SESSION, handler);
        app.post(this.path + SESSION + "/*", handler);
        app.get(this.path + SESSION + "/*", handler);
        app.delete(this.path + SESSION + "/*", handler);
        String localHostAddress = this.getLocalHostAddress();
        log.info("WebDriverManager Server listening on http://{}:{}{}", new Object[]{localHostAddress, port, this.path});
    }

    private String getLocalHostAddress() {
        String localHostAddress;
        try {
            localHostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            localHostAddress = InetAddress.getLoopbackAddress().getHostAddress();
        }
        return localHostAddress;
    }

    private void handleRequest(Context ctx) throws IOException {
        String requestMethod = ctx.method();
        String requestPath = ctx.path();
        log.info("Request: {} {}", (Object)requestMethod, (Object)requestPath);
        Optional<WebDriverManager> driverManager = this.createDriverManager(requestPath);
        if (driverManager.isPresent()) {
            this.resolveDriver(ctx, driverManager.get());
        } else {
            this.seleniumServer(ctx);
        }
    }

    private void seleniumServer(Context ctx) throws IOException {
        URL seleniumServerUrl;
        String requestMethod = ctx.method();
        String requestPath = ctx.path().replace(this.path, "");
        String requestBody = ctx.body();
        log.debug("Body: {} ", (Object)requestBody);
        Session session = (Session)new Gson().fromJson(requestBody, Session.class);
        boolean isSessionCreate = session != null && session.getCapabilities() != null && session.getCapabilities().getFirstMatch() != null;
        WebDriverManager wdm = null;
        if (isSessionCreate) {
            String browserName = session.getCapabilities().getFirstMatch().get(0).getBrowserName();
            String version = session.getCapabilities().getFirstMatch().get(0).getVersion();
            wdm = WebDriverManager.getInstance(browserName).browserInDocker().browserVersion(version);
            wdm.create();
            seleniumServerUrl = wdm.getDockerSeleniumServerUrl();
        } else {
            String sessionIdFromPath = this.getSessionIdFromPath(requestPath);
            seleniumServerUrl = this.sessionMap.get(sessionIdFromPath);
        }
        String response = this.exchange(seleniumServerUrl.toString().replaceAll("/\\z", "") + requestPath, requestMethod, requestBody, this.config.getServerTimeoutSec());
        log.info("Response: {}", (Object)response);
        ctx.contentType("application/json");
        ctx.result(response);
        if (isSessionCreate) {
            String sessionId = this.getSessionIdFromResponse(response);
            this.sessionMap.put(sessionId, seleniumServerUrl);
            this.wdmMap.put(sessionId, wdm);
        }
        if (requestMethod.equalsIgnoreCase(DELETE) && requestPath.startsWith("/session/")) {
            String sessionIdFromPath = this.getSessionIdFromPath(requestPath);
            this.wdmMap.get(sessionIdFromPath).quit();
            this.wdmMap.remove(sessionIdFromPath);
            this.sessionMap.remove(sessionIdFromPath);
        }
    }

    private String getSessionIdFromResponse(String response) {
        response = response.substring(response.indexOf(SESSIONID) + SESSIONID.length() + 1);
        response = response.substring(0, response.indexOf("\""));
        return response;
    }

    private String getSessionIdFromPath(String path) {
        path = path.substring(path.indexOf("/") + 1);
        int i = (path = path.substring(path.indexOf("/") + 1)).indexOf("/");
        if (i != -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    private Optional<WebDriverManager> createDriverManager(String requestPath) {
        Optional<WebDriverManager> out;
        switch (requestPath.replace(this.path, "").substring(1)) {
            case "chromedriver": {
                out = Optional.of(WebDriverManager.chromedriver());
                break;
            }
            case "firefoxdriver": {
                out = Optional.of(WebDriverManager.firefoxdriver());
                break;
            }
            case "edgedriver": {
                out = Optional.of(WebDriverManager.edgedriver());
                break;
            }
            case "iedriver": {
                out = Optional.of(WebDriverManager.iedriver());
                break;
            }
            case "operadriver": {
                out = Optional.of(WebDriverManager.operadriver());
                break;
            }
            default: {
                out = Optional.empty();
            }
        }
        return out;
    }

    private synchronized void resolveDriver(Context ctx, WebDriverManager driverManager) throws IOException {
        TreeMap queryParamMap = new TreeMap(ctx.queryParamMap());
        if (!queryParamMap.isEmpty()) {
            log.info("Server query string for configuration {}", queryParamMap);
            for (Map.Entry entry : queryParamMap.entrySet()) {
                String configKey = "wdm." + (String)entry.getKey();
                String configValue = (String)((List)entry.getValue()).get(0);
                log.trace("\t{} = {}", (Object)configKey, (Object)configValue);
                System.setProperty(configKey, configValue);
            }
        }
        driverManager.config().setAvoidExport(true);
        driverManager.config().setAvoidBrowserDetection(true);
        driverManager.setup();
        File driver = new File(driverManager.getDownloadedDriverPath());
        String driverVersion = driverManager.getDownloadedDriverVersion();
        String driverName = driver.getName();
        String driverLength = String.valueOf(driver.length());
        ctx.res.setHeader("Content-Disposition", "attachment; filename=\"" + driverName + "\"");
        ctx.result((InputStream)FileUtils.openInputStream((File)driver));
        log.info("Server response: {} {} ({} bytes)", new Object[]{driverName, driverVersion, driverLength});
        for (String key : queryParamMap.keySet()) {
            System.clearProperty("wdm." + key);
        }
    }

    public String exchange(String url, String method, String json, int timeoutSec) throws IOException {
        String responseContent = null;
        BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager();
        connectionManager.setConnectionConfig(ConnectionConfig.custom().setConnectTimeout((long)timeoutSec, TimeUnit.SECONDS).build());
        try (CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).build();){
            HttpGet request = null;
            switch (method) {
                case "GET": {
                    request = new HttpGet(url);
                    break;
                }
                case "DELETE": {
                    request = new HttpDelete(url);
                    break;
                }
                default: {
                    request = new HttpPost(url);
                    StringEntity body = new StringEntity(json);
                    request.setEntity((HttpEntity)body);
                    request.setHeader("Content-Type", (Object)"application/json");
                }
            }
            try (ClassicHttpResponse response = closeableHttpClient.executeOpen(null, (ClassicHttpRequest)request, (HttpContext)HttpClientContext.create());){
                responseContent = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            }
        }
        return responseContent;
    }

    static class FirstMatch {
        String browserName;
        String version;

        FirstMatch() {
        }

        public String getBrowserName() {
            return this.browserName;
        }

        public String getVersion() {
            return this.version;
        }
    }

    static class Capabilities {
        List<FirstMatch> firstMatch;

        Capabilities() {
        }

        public List<FirstMatch> getFirstMatch() {
            return this.firstMatch;
        }
    }

    static class Session {
        Capabilities capabilities;

        Session() {
        }

        public Capabilities getCapabilities() {
            return this.capabilities;
        }
    }
}

