/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.config;

import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.common.dto.NotifyPlatform;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="spring.dynamic.tp")
public class DtpProperties {
    private static final Logger log = LoggerFactory.getLogger(DtpProperties.class);
    private boolean enabled = true;
    private boolean enabledBanner = true;
    private Nacos nacos;
    private Apollo apollo;
    private String configType = "yml";
    private boolean enabledCollect = false;
    public String collectorType = "logging";
    public String logPath;
    private int monitorInterval = 5;
    private List<ThreadPoolProperties> executors;
    private List<NotifyPlatform> platforms;

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnabledBanner() {
        return this.enabledBanner;
    }

    public Nacos getNacos() {
        return this.nacos;
    }

    public Apollo getApollo() {
        return this.apollo;
    }

    public String getConfigType() {
        return this.configType;
    }

    public boolean isEnabledCollect() {
        return this.enabledCollect;
    }

    public String getCollectorType() {
        return this.collectorType;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public List<ThreadPoolProperties> getExecutors() {
        return this.executors;
    }

    public List<NotifyPlatform> getPlatforms() {
        return this.platforms;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEnabledBanner(boolean enabledBanner) {
        this.enabledBanner = enabledBanner;
    }

    public void setNacos(Nacos nacos) {
        this.nacos = nacos;
    }

    public void setApollo(Apollo apollo) {
        this.apollo = apollo;
    }

    public void setConfigType(String configType) {
        this.configType = configType;
    }

    public void setEnabledCollect(boolean enabledCollect) {
        this.enabledCollect = enabledCollect;
    }

    public void setCollectorType(String collectorType) {
        this.collectorType = collectorType;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
    }

    public void setExecutors(List<ThreadPoolProperties> executors) {
        this.executors = executors;
    }

    public void setPlatforms(List<NotifyPlatform> platforms) {
        this.platforms = platforms;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DtpProperties)) {
            return false;
        }
        DtpProperties other = (DtpProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isEnabledBanner() != other.isEnabledBanner()) {
            return false;
        }
        if (this.isEnabledCollect() != other.isEnabledCollect()) {
            return false;
        }
        if (this.getMonitorInterval() != other.getMonitorInterval()) {
            return false;
        }
        Nacos this$nacos = this.getNacos();
        Nacos other$nacos = other.getNacos();
        if (this$nacos == null ? other$nacos != null : !((Object)this$nacos).equals(other$nacos)) {
            return false;
        }
        Apollo this$apollo = this.getApollo();
        Apollo other$apollo = other.getApollo();
        if (this$apollo == null ? other$apollo != null : !((Object)this$apollo).equals(other$apollo)) {
            return false;
        }
        String this$configType = this.getConfigType();
        String other$configType = other.getConfigType();
        if (this$configType == null ? other$configType != null : !this$configType.equals(other$configType)) {
            return false;
        }
        String this$collectorType = this.getCollectorType();
        String other$collectorType = other.getCollectorType();
        if (this$collectorType == null ? other$collectorType != null : !this$collectorType.equals(other$collectorType)) {
            return false;
        }
        String this$logPath = this.getLogPath();
        String other$logPath = other.getLogPath();
        if (this$logPath == null ? other$logPath != null : !this$logPath.equals(other$logPath)) {
            return false;
        }
        List<ThreadPoolProperties> this$executors = this.getExecutors();
        List<ThreadPoolProperties> other$executors = other.getExecutors();
        if (this$executors == null ? other$executors != null : !((Object)this$executors).equals(other$executors)) {
            return false;
        }
        List<NotifyPlatform> this$platforms = this.getPlatforms();
        List<NotifyPlatform> other$platforms = other.getPlatforms();
        return !(this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DtpProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isEnabledBanner() ? 79 : 97);
        result = result * 59 + (this.isEnabledCollect() ? 79 : 97);
        result = result * 59 + this.getMonitorInterval();
        Nacos $nacos = this.getNacos();
        result = result * 59 + ($nacos == null ? 43 : ((Object)$nacos).hashCode());
        Apollo $apollo = this.getApollo();
        result = result * 59 + ($apollo == null ? 43 : ((Object)$apollo).hashCode());
        String $configType = this.getConfigType();
        result = result * 59 + ($configType == null ? 43 : $configType.hashCode());
        String $collectorType = this.getCollectorType();
        result = result * 59 + ($collectorType == null ? 43 : $collectorType.hashCode());
        String $logPath = this.getLogPath();
        result = result * 59 + ($logPath == null ? 43 : $logPath.hashCode());
        List<ThreadPoolProperties> $executors = this.getExecutors();
        result = result * 59 + ($executors == null ? 43 : ((Object)$executors).hashCode());
        List<NotifyPlatform> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        return result;
    }

    public String toString() {
        return "DtpProperties(enabled=" + this.isEnabled() + ", enabledBanner=" + this.isEnabledBanner() + ", nacos=" + this.getNacos() + ", apollo=" + this.getApollo() + ", configType=" + this.getConfigType() + ", enabledCollect=" + this.isEnabledCollect() + ", collectorType=" + this.getCollectorType() + ", logPath=" + this.getLogPath() + ", monitorInterval=" + this.getMonitorInterval() + ", executors=" + this.getExecutors() + ", platforms=" + this.getPlatforms() + ")";
    }

    public static class Apollo {
        private String namespace = "application";

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Apollo)) {
                return false;
            }
            Apollo other = (Apollo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Apollo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        public String toString() {
            return "DtpProperties.Apollo(namespace=" + this.getNamespace() + ")";
        }
    }

    public static class Nacos {
        private String dataId;
        private String group = "DEFAULT_GROUP";
        private String namespace = "public";

        public String getDataId() {
            return this.dataId;
        }

        public String getGroup() {
            return this.group;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Nacos)) {
                return false;
            }
            Nacos other = (Nacos)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$dataId = this.getDataId();
            String other$dataId = other.getDataId();
            if (this$dataId == null ? other$dataId != null : !this$dataId.equals(other$dataId)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            return !(this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Nacos;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $dataId = this.getDataId();
            result = result * 59 + ($dataId == null ? 43 : $dataId.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            return result;
        }

        public String toString() {
            return "DtpProperties.Nacos(dataId=" + this.getDataId() + ", group=" + this.getGroup() + ", namespace=" + this.getNamespace() + ")";
        }
    }
}

