/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.starter.cloud.nacos.refresh;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.dtp.common.config.DtpProperties;
import com.dtp.common.em.ConfigFileTypeEnum;
import com.dtp.common.util.NacosUtil;
import com.dtp.core.refresh.AbstractRefresher;
import com.dtp.core.support.DtpCreator;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.Environment;

public class CloudNacosRefresher
extends AbstractRefresher
implements InitializingBean,
Listener {
    private static final Logger log = LoggerFactory.getLogger(CloudNacosRefresher.class);
    private static final ThreadPoolExecutor EXECUTOR = DtpCreator.createCommonFast((String)"nacos-listener");
    private ConfigFileTypeEnum configFileType;
    @Resource
    private NacosConfigManager nacosConfigManager;
    @Resource
    private DtpProperties dtpProperties;
    @Resource
    private NacosConfigProperties nacosConfigProperties;
    @Resource
    private Environment environment;

    public void afterPropertiesSet() {
        DtpProperties.Nacos nacos = this.dtpProperties.getNacos();
        this.configFileType = NacosUtil.getConfigType((DtpProperties)this.dtpProperties, (ConfigFileTypeEnum)ConfigFileTypeEnum.of((String)this.nacosConfigProperties.getFileExtension()));
        String dataId = NacosUtil.deduceDataId((DtpProperties.Nacos)nacos, (Environment)this.environment, (ConfigFileTypeEnum)this.configFileType);
        String group = NacosUtil.getGroup((DtpProperties.Nacos)nacos, (String)this.nacosConfigProperties.getGroup());
        try {
            this.nacosConfigManager.getConfigService().addListener(dataId, group, (Listener)this);
        }
        catch (NacosException e) {
            log.error("DynamicTp refresher, {} addListener error", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    public Executor getExecutor() {
        return EXECUTOR;
    }

    public void receiveConfigInfo(String content) {
        this.refresh(content, this.configFileType);
    }
}

