/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.media.jsonp;

import io.helidon.common.GenericType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpMediaType;
import io.helidon.http.WritableHeaders;
import io.helidon.http.media.EntityWriter;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Optional;

class JsonpWriter<T extends JsonStructure>
implements EntityWriter<T> {
    private final JsonWriterFactory writerFactory;

    JsonpWriter(JsonWriterFactory writerFactory) {
        this.writerFactory = writerFactory;
    }

    public void write(GenericType<T> type, T object, OutputStream outputStream, Headers requestHeaders, WritableHeaders<?> responseHeaders) {
        responseHeaders.setIfAbsent(HeaderValues.CONTENT_TYPE_JSON);
        for (HttpMediaType acceptedType : requestHeaders.acceptedTypes()) {
            if (!acceptedType.test(MediaTypes.APPLICATION_JSON)) continue;
            Optional charset = acceptedType.charset();
            if (charset.isPresent()) {
                Charset characterSet = Charset.forName((String)charset.get());
                this.write(object, new OutputStreamWriter(outputStream, characterSet));
            } else {
                this.write(object, outputStream);
            }
            return;
        }
        this.write(object, outputStream);
    }

    public void write(GenericType<T> type, T object, OutputStream outputStream, WritableHeaders<?> headers) {
        headers.setIfAbsent(HeaderValues.CONTENT_TYPE_JSON);
        this.write(object, outputStream);
    }

    private void write(T object, Writer out) {
        JsonWriter writer = this.writerFactory.createWriter(out);
        writer.write(object);
    }

    private void write(T object, OutputStream out) {
        try (OutputStream outputStream = out;){
            this.writerFactory.createWriter(out).write(object);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

