/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.integrations.langchain4j.providers.openai;

import dev.langchain4j.model.Tokenizer;
import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.integrations.langchain4j.providers.openai.OpenAiStreamingChatModelConfigBlueprint;
import java.net.Proxy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.integrations.langchain4j.providers.openai.OpenAiStreamingChatModelConfigBlueprint")
public interface OpenAiStreamingChatModelConfig
extends OpenAiStreamingChatModelConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OpenAiStreamingChatModelConfig instance) {
        return (Builder)OpenAiStreamingChatModelConfig.builder().from(instance);
    }

    public static OpenAiStreamingChatModelConfig create(Config config) {
        return ((Builder)OpenAiStreamingChatModelConfig.builder().config(config)).buildPrototype();
    }

    public static OpenAiStreamingChatModelConfig create() {
        return OpenAiStreamingChatModelConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, OpenAiStreamingChatModelConfig>
    implements io.helidon.common.Builder<Builder, OpenAiStreamingChatModelConfig> {
        private Builder() {
        }

        public OpenAiStreamingChatModelConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OpenAiStreamingChatModelConfigImpl(this);
        }

        public OpenAiStreamingChatModelConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OpenAiStreamingChatModelConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<String> stop = new ArrayList<String>();
        private final Map<String, Integer> logitBias = new LinkedHashMap<String, Integer>();
        private final Map<String, String> customHeaders = new LinkedHashMap<String, String>();
        private Boolean logRequests;
        private Boolean logResponses;
        private Boolean parallelToolCalls;
        private Boolean strictTools;
        private boolean enabled;
        private boolean isStopMutated;
        private Config config;
        private Double frequencyPenalty;
        private Double presencePenalty;
        private Double temperature;
        private Double topP;
        private Duration timeout;
        private Integer maxCompletionTokens;
        private Integer maxTokens;
        private Integer seed;
        private Proxy proxy;
        private String apiKey;
        private String baseUrl;
        private String modelName;
        private String organizationId;
        private String responseFormat;
        private String user;
        private Tokenizer tokenizer;

        protected BuilderBase() {
        }

        public BUILDER from(OpenAiStreamingChatModelConfig prototype) {
            this.temperature(prototype.temperature());
            this.topP(prototype.topP());
            if (!this.isStopMutated) {
                this.stop.clear();
            }
            this.addStop(prototype.stop());
            this.maxTokens(prototype.maxTokens());
            this.maxCompletionTokens(prototype.maxCompletionTokens());
            this.presencePenalty(prototype.presencePenalty());
            this.frequencyPenalty(prototype.frequencyPenalty());
            this.addLogitBias(prototype.logitBias());
            this.responseFormat(prototype.responseFormat());
            this.seed(prototype.seed());
            this.user(prototype.user());
            this.strictTools(prototype.strictTools());
            this.parallelToolCalls(prototype.parallelToolCalls());
            this.tokenizer(prototype.tokenizer());
            this.enabled(prototype.enabled());
            this.baseUrl(prototype.baseUrl());
            this.apiKey(prototype.apiKey());
            this.logRequests(prototype.logRequests());
            this.logResponses(prototype.logResponses());
            this.addCustomHeaders(prototype.customHeaders());
            this.timeout(prototype.timeout());
            this.proxy(prototype.proxy());
            this.organizationId(prototype.organizationId());
            this.modelName(prototype.modelName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.temperature().ifPresent(this::temperature);
            builder.topP().ifPresent(this::topP);
            if (this.isStopMutated) {
                if (builder.isStopMutated) {
                    this.addStop(builder.stop);
                }
            } else {
                this.stop.clear();
                this.addStop(builder.stop);
            }
            builder.maxTokens().ifPresent(this::maxTokens);
            builder.maxCompletionTokens().ifPresent(this::maxCompletionTokens);
            builder.presencePenalty().ifPresent(this::presencePenalty);
            builder.frequencyPenalty().ifPresent(this::frequencyPenalty);
            this.addLogitBias(builder.logitBias);
            builder.responseFormat().ifPresent(this::responseFormat);
            builder.seed().ifPresent(this::seed);
            builder.user().ifPresent(this::user);
            builder.strictTools().ifPresent(this::strictTools);
            builder.parallelToolCalls().ifPresent(this::parallelToolCalls);
            builder.tokenizer().ifPresent(this::tokenizer);
            this.enabled(builder.enabled());
            builder.baseUrl().ifPresent(this::baseUrl);
            builder.apiKey().ifPresent(this::apiKey);
            builder.logRequests().ifPresent(this::logRequests);
            builder.logResponses().ifPresent(this::logResponses);
            this.addCustomHeaders(builder.customHeaders);
            builder.timeout().ifPresent(this::timeout);
            builder.proxy().ifPresent(this::proxy);
            builder.organizationId().ifPresent(this::organizationId);
            builder.modelName().ifPresent(this::modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("temperature").as(Double.class).ifPresent(this::temperature);
            config.get("top-p").as(Double.class).ifPresent(this::topP);
            config.get("stop").asList(String.class).ifPresent(this::stop);
            config.get("max-tokens").as(Integer.class).ifPresent(this::maxTokens);
            config.get("max-completion-tokens").as(Integer.class).ifPresent(this::maxCompletionTokens);
            config.get("presence-penalty").as(Double.class).ifPresent(this::presencePenalty);
            config.get("frequency-penalty").as(Double.class).ifPresent(this::frequencyPenalty);
            config.get("logit-bias").asNodeList().ifPresent(nodes -> nodes.forEach(node -> this.logitBias.put((String)node.get("name").asString().orElse((Object)node.name()), (Integer)node.as(Integer.class).get())));
            config.get("response-format").as(String.class).ifPresent(this::responseFormat);
            config.get("seed").as(Integer.class).ifPresent(this::seed);
            config.get("user").as(String.class).ifPresent(this::user);
            config.get("strict-tools").as(Boolean.class).ifPresent(this::strictTools);
            config.get("parallel-tool-calls").as(Boolean.class).ifPresent(this::parallelToolCalls);
            config.get("enabled").as(Boolean.class).ifPresent(this::enabled);
            config.get("base-url").as(String.class).ifPresent(this::baseUrl);
            config.get("api-key").as(String.class).ifPresent(this::apiKey);
            config.get("log-requests").as(Boolean.class).ifPresent(this::logRequests);
            config.get("log-responses").as(Boolean.class).ifPresent(this::logResponses);
            config.get("custom-headers").detach().asMap().ifPresent(this::customHeaders);
            config.get("timeout").as(Duration.class).ifPresent(this::timeout);
            config.get("organization-id").as(String.class).ifPresent(this::organizationId);
            config.get("model-name").as(String.class).ifPresent(this::modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTemperature() {
            this.temperature = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER temperature(double temperature) {
            Objects.requireNonNull(temperature);
            this.temperature = temperature;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTopP() {
            this.topP = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER topP(double topP) {
            Objects.requireNonNull(topP);
            this.topP = topP;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER stop(List<String> stop) {
            Objects.requireNonNull(stop);
            this.isStopMutated = true;
            this.stop.clear();
            this.stop.addAll(stop);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addStop(List<String> stop) {
            Objects.requireNonNull(stop);
            this.isStopMutated = true;
            this.stop.addAll(stop);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaxTokens() {
            this.maxTokens = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxTokens(int maxTokens) {
            Objects.requireNonNull(maxTokens);
            this.maxTokens = maxTokens;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMaxCompletionTokens() {
            this.maxCompletionTokens = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxCompletionTokens(int maxCompletionTokens) {
            Objects.requireNonNull(maxCompletionTokens);
            this.maxCompletionTokens = maxCompletionTokens;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearPresencePenalty() {
            this.presencePenalty = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER presencePenalty(double presencePenalty) {
            Objects.requireNonNull(presencePenalty);
            this.presencePenalty = presencePenalty;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFrequencyPenalty() {
            this.frequencyPenalty = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER frequencyPenalty(double frequencyPenalty) {
            Objects.requireNonNull(frequencyPenalty);
            this.frequencyPenalty = frequencyPenalty;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER logitBias(Map<String, Integer> logitBias) {
            Objects.requireNonNull(logitBias);
            this.logitBias.clear();
            this.logitBias.putAll(logitBias);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addLogitBias(Map<String, Integer> logitBias) {
            Objects.requireNonNull(logitBias);
            this.logitBias.putAll(logitBias);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putLogitBia(String key, Integer logitBia) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(logitBia);
            this.logitBias.put(key, logitBia);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearResponseFormat() {
            this.responseFormat = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER responseFormat(String responseFormat) {
            Objects.requireNonNull(responseFormat);
            this.responseFormat = responseFormat;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearSeed() {
            this.seed = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER seed(int seed) {
            Objects.requireNonNull(seed);
            this.seed = seed;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearUser() {
            this.user = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER user(String user) {
            Objects.requireNonNull(user);
            this.user = user;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearStrictTools() {
            this.strictTools = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER strictTools(boolean strictTools) {
            Objects.requireNonNull(strictTools);
            this.strictTools = strictTools;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearParallelToolCalls() {
            this.parallelToolCalls = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER parallelToolCalls(boolean parallelToolCalls) {
            Objects.requireNonNull(parallelToolCalls);
            this.parallelToolCalls = parallelToolCalls;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTokenizer() {
            this.tokenizer = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tokenizer(Tokenizer tokenizer) {
            Objects.requireNonNull(tokenizer);
            this.tokenizer = tokenizer;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enabled(boolean enabled) {
            this.enabled = enabled;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearBaseUrl() {
            this.baseUrl = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER baseUrl(String baseUrl) {
            Objects.requireNonNull(baseUrl);
            this.baseUrl = baseUrl;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearApiKey() {
            this.apiKey = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER apiKey(String apiKey) {
            Objects.requireNonNull(apiKey);
            this.apiKey = apiKey;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearLogRequests() {
            this.logRequests = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER logRequests(boolean logRequests) {
            Objects.requireNonNull(logRequests);
            this.logRequests = logRequests;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearLogResponses() {
            this.logResponses = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER logResponses(boolean logResponses) {
            Objects.requireNonNull(logResponses);
            this.logResponses = logResponses;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER customHeaders(Map<String, String> customHeaders) {
            Objects.requireNonNull(customHeaders);
            this.customHeaders.clear();
            this.customHeaders.putAll(customHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addCustomHeaders(Map<String, String> customHeaders) {
            Objects.requireNonNull(customHeaders);
            this.customHeaders.putAll(customHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER putCustomHeader(String key, String customHeader) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(customHeader);
            this.customHeaders.put(key, customHeader);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTimeout() {
            this.timeout = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER timeout(Duration timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearProxy() {
            this.proxy = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER proxy(Proxy proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearOrganizationId() {
            this.organizationId = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER organizationId(String organizationId) {
            Objects.requireNonNull(organizationId);
            this.organizationId = organizationId;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearModelName() {
            this.modelName = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER modelName(String modelName) {
            Objects.requireNonNull(modelName);
            this.modelName = modelName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<Double> temperature() {
            return Optional.ofNullable(this.temperature);
        }

        public Optional<Double> topP() {
            return Optional.ofNullable(this.topP);
        }

        public List<String> stop() {
            return this.stop;
        }

        public Optional<Integer> maxTokens() {
            return Optional.ofNullable(this.maxTokens);
        }

        public Optional<Integer> maxCompletionTokens() {
            return Optional.ofNullable(this.maxCompletionTokens);
        }

        public Optional<Double> presencePenalty() {
            return Optional.ofNullable(this.presencePenalty);
        }

        public Optional<Double> frequencyPenalty() {
            return Optional.ofNullable(this.frequencyPenalty);
        }

        public Map<String, Integer> logitBias() {
            return this.logitBias;
        }

        public Optional<String> responseFormat() {
            return Optional.ofNullable(this.responseFormat);
        }

        public Optional<Integer> seed() {
            return Optional.ofNullable(this.seed);
        }

        public Optional<String> user() {
            return Optional.ofNullable(this.user);
        }

        public Optional<Boolean> strictTools() {
            return Optional.ofNullable(this.strictTools);
        }

        public Optional<Boolean> parallelToolCalls() {
            return Optional.ofNullable(this.parallelToolCalls);
        }

        public Optional<Tokenizer> tokenizer() {
            return Optional.ofNullable(this.tokenizer);
        }

        public boolean enabled() {
            return this.enabled;
        }

        public Optional<String> baseUrl() {
            return Optional.ofNullable(this.baseUrl);
        }

        public Optional<String> apiKey() {
            return Optional.ofNullable(this.apiKey);
        }

        public Optional<Boolean> logRequests() {
            return Optional.ofNullable(this.logRequests);
        }

        public Optional<Boolean> logResponses() {
            return Optional.ofNullable(this.logResponses);
        }

        public Map<String, String> customHeaders() {
            return this.customHeaders;
        }

        public Optional<Duration> timeout() {
            return Optional.ofNullable(this.timeout);
        }

        public Optional<Proxy> proxy() {
            return Optional.ofNullable(this.proxy);
        }

        public Optional<String> organizationId() {
            return Optional.ofNullable(this.organizationId);
        }

        public Optional<String> modelName() {
            return Optional.ofNullable(this.modelName);
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "OpenAiStreamingChatModelConfigBuilder{temperature=" + this.temperature + ",topP=" + this.topP + ",stop=" + String.valueOf(this.stop) + ",maxTokens=" + this.maxTokens + ",maxCompletionTokens=" + this.maxCompletionTokens + ",presencePenalty=" + this.presencePenalty + ",frequencyPenalty=" + this.frequencyPenalty + ",logitBias=" + String.valueOf(this.logitBias) + ",responseFormat=" + this.responseFormat + ",seed=" + this.seed + ",user=" + this.user + ",strictTools=" + this.strictTools + ",parallelToolCalls=" + this.parallelToolCalls + ",tokenizer=" + String.valueOf(this.tokenizer) + ",enabled=" + this.enabled + ",baseUrl=" + this.baseUrl + ",apiKey=" + this.apiKey + ",logRequests=" + this.logRequests + ",logResponses=" + this.logResponses + ",customHeaders=" + String.valueOf(this.customHeaders) + ",timeout=" + String.valueOf(this.timeout) + ",proxy=" + String.valueOf(this.proxy) + ",organizationId=" + this.organizationId + ",modelName=" + this.modelName + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER temperature(Optional<Double> temperature) {
            Objects.requireNonNull(temperature);
            this.temperature = temperature.map(Double.class::cast).orElse(this.temperature);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER topP(Optional<Double> topP) {
            Objects.requireNonNull(topP);
            this.topP = topP.map(Double.class::cast).orElse(this.topP);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER maxTokens(Optional<Integer> maxTokens) {
            Objects.requireNonNull(maxTokens);
            this.maxTokens = maxTokens.map(Integer.class::cast).orElse(this.maxTokens);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER maxCompletionTokens(Optional<Integer> maxCompletionTokens) {
            Objects.requireNonNull(maxCompletionTokens);
            this.maxCompletionTokens = maxCompletionTokens.map(Integer.class::cast).orElse(this.maxCompletionTokens);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER presencePenalty(Optional<Double> presencePenalty) {
            Objects.requireNonNull(presencePenalty);
            this.presencePenalty = presencePenalty.map(Double.class::cast).orElse(this.presencePenalty);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER frequencyPenalty(Optional<Double> frequencyPenalty) {
            Objects.requireNonNull(frequencyPenalty);
            this.frequencyPenalty = frequencyPenalty.map(Double.class::cast).orElse(this.frequencyPenalty);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER responseFormat(Optional<String> responseFormat) {
            Objects.requireNonNull(responseFormat);
            this.responseFormat = responseFormat.map(String.class::cast).orElse(this.responseFormat);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER seed(Optional<Integer> seed) {
            Objects.requireNonNull(seed);
            this.seed = seed.map(Integer.class::cast).orElse(this.seed);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER user(Optional<String> user) {
            Objects.requireNonNull(user);
            this.user = user.map(String.class::cast).orElse(this.user);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER strictTools(Optional<Boolean> strictTools) {
            Objects.requireNonNull(strictTools);
            this.strictTools = strictTools.map(Boolean.class::cast).orElse(this.strictTools);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER parallelToolCalls(Optional<Boolean> parallelToolCalls) {
            Objects.requireNonNull(parallelToolCalls);
            this.parallelToolCalls = parallelToolCalls.map(Boolean.class::cast).orElse(this.parallelToolCalls);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER tokenizer(Optional<? extends Tokenizer> tokenizer) {
            Objects.requireNonNull(tokenizer);
            this.tokenizer = tokenizer.map(Tokenizer.class::cast).orElse(this.tokenizer);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER baseUrl(Optional<String> baseUrl) {
            Objects.requireNonNull(baseUrl);
            this.baseUrl = baseUrl.map(String.class::cast).orElse(this.baseUrl);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER apiKey(Optional<String> apiKey) {
            Objects.requireNonNull(apiKey);
            this.apiKey = apiKey.map(String.class::cast).orElse(this.apiKey);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER logRequests(Optional<Boolean> logRequests) {
            Objects.requireNonNull(logRequests);
            this.logRequests = logRequests.map(Boolean.class::cast).orElse(this.logRequests);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER logResponses(Optional<Boolean> logResponses) {
            Objects.requireNonNull(logResponses);
            this.logResponses = logResponses.map(Boolean.class::cast).orElse(this.logResponses);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER timeout(Optional<? extends Duration> timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout.map(Duration.class::cast).orElse(this.timeout);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER proxy(Optional<? extends Proxy> proxy) {
            Objects.requireNonNull(proxy);
            this.proxy = proxy.map(Proxy.class::cast).orElse(this.proxy);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER organizationId(Optional<String> organizationId) {
            Objects.requireNonNull(organizationId);
            this.organizationId = organizationId.map(String.class::cast).orElse(this.organizationId);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER modelName(Optional<String> modelName) {
            Objects.requireNonNull(modelName);
            this.modelName = modelName.map(String.class::cast).orElse(this.modelName);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class OpenAiStreamingChatModelConfigImpl
        implements OpenAiStreamingChatModelConfig {
            private final boolean enabled;
            private final List<String> stop;
            private final Map<String, Integer> logitBias;
            private final Map<String, String> customHeaders;
            private final Optional<Tokenizer> tokenizer;
            private final Optional<Boolean> logRequests;
            private final Optional<Boolean> logResponses;
            private final Optional<Boolean> parallelToolCalls;
            private final Optional<Boolean> strictTools;
            private final Optional<Double> frequencyPenalty;
            private final Optional<Double> presencePenalty;
            private final Optional<Double> temperature;
            private final Optional<Double> topP;
            private final Optional<Integer> maxCompletionTokens;
            private final Optional<Integer> maxTokens;
            private final Optional<Integer> seed;
            private final Optional<String> apiKey;
            private final Optional<String> baseUrl;
            private final Optional<String> modelName;
            private final Optional<String> organizationId;
            private final Optional<String> responseFormat;
            private final Optional<String> user;
            private final Optional<Proxy> proxy;
            private final Optional<Duration> timeout;

            protected OpenAiStreamingChatModelConfigImpl(BuilderBase<?, ?> builder) {
                this.temperature = builder.temperature();
                this.topP = builder.topP();
                this.stop = List.copyOf(builder.stop());
                this.maxTokens = builder.maxTokens();
                this.maxCompletionTokens = builder.maxCompletionTokens();
                this.presencePenalty = builder.presencePenalty();
                this.frequencyPenalty = builder.frequencyPenalty();
                this.logitBias = Collections.unmodifiableMap(new LinkedHashMap<String, Integer>(builder.logitBias()));
                this.responseFormat = builder.responseFormat();
                this.seed = builder.seed();
                this.user = builder.user();
                this.strictTools = builder.strictTools();
                this.parallelToolCalls = builder.parallelToolCalls();
                this.tokenizer = builder.tokenizer();
                this.enabled = builder.enabled();
                this.baseUrl = builder.baseUrl();
                this.apiKey = builder.apiKey();
                this.logRequests = builder.logRequests();
                this.logResponses = builder.logResponses();
                this.customHeaders = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.customHeaders()));
                this.timeout = builder.timeout();
                this.proxy = builder.proxy();
                this.organizationId = builder.organizationId();
                this.modelName = builder.modelName();
            }

            @Override
            public Optional<Double> temperature() {
                return this.temperature;
            }

            @Override
            public Optional<Double> topP() {
                return this.topP;
            }

            @Override
            public List<String> stop() {
                return this.stop;
            }

            @Override
            public Optional<Integer> maxTokens() {
                return this.maxTokens;
            }

            @Override
            public Optional<Integer> maxCompletionTokens() {
                return this.maxCompletionTokens;
            }

            @Override
            public Optional<Double> presencePenalty() {
                return this.presencePenalty;
            }

            @Override
            public Optional<Double> frequencyPenalty() {
                return this.frequencyPenalty;
            }

            @Override
            public Map<String, Integer> logitBias() {
                return this.logitBias;
            }

            @Override
            public Optional<String> responseFormat() {
                return this.responseFormat;
            }

            @Override
            public Optional<Integer> seed() {
                return this.seed;
            }

            @Override
            public Optional<String> user() {
                return this.user;
            }

            @Override
            public Optional<Boolean> strictTools() {
                return this.strictTools;
            }

            @Override
            public Optional<Boolean> parallelToolCalls() {
                return this.parallelToolCalls;
            }

            @Override
            public Optional<Tokenizer> tokenizer() {
                return this.tokenizer;
            }

            @Override
            public boolean enabled() {
                return this.enabled;
            }

            @Override
            public Optional<String> baseUrl() {
                return this.baseUrl;
            }

            @Override
            public Optional<String> apiKey() {
                return this.apiKey;
            }

            @Override
            public Optional<Boolean> logRequests() {
                return this.logRequests;
            }

            @Override
            public Optional<Boolean> logResponses() {
                return this.logResponses;
            }

            @Override
            public Map<String, String> customHeaders() {
                return this.customHeaders;
            }

            @Override
            public Optional<Duration> timeout() {
                return this.timeout;
            }

            @Override
            public Optional<Proxy> proxy() {
                return this.proxy;
            }

            @Override
            public Optional<String> organizationId() {
                return this.organizationId;
            }

            @Override
            public Optional<String> modelName() {
                return this.modelName;
            }

            public String toString() {
                return "OpenAiStreamingChatModelConfig{temperature=" + String.valueOf(this.temperature) + ",topP=" + String.valueOf(this.topP) + ",stop=" + String.valueOf(this.stop) + ",maxTokens=" + String.valueOf(this.maxTokens) + ",maxCompletionTokens=" + String.valueOf(this.maxCompletionTokens) + ",presencePenalty=" + String.valueOf(this.presencePenalty) + ",frequencyPenalty=" + String.valueOf(this.frequencyPenalty) + ",logitBias=" + String.valueOf(this.logitBias) + ",responseFormat=" + String.valueOf(this.responseFormat) + ",seed=" + String.valueOf(this.seed) + ",user=" + String.valueOf(this.user) + ",strictTools=" + String.valueOf(this.strictTools) + ",parallelToolCalls=" + String.valueOf(this.parallelToolCalls) + ",tokenizer=" + String.valueOf(this.tokenizer) + ",enabled=" + this.enabled + ",baseUrl=" + String.valueOf(this.baseUrl) + ",apiKey=" + String.valueOf(this.apiKey) + ",logRequests=" + String.valueOf(this.logRequests) + ",logResponses=" + String.valueOf(this.logResponses) + ",customHeaders=" + String.valueOf(this.customHeaders) + ",timeout=" + String.valueOf(this.timeout) + ",proxy=" + String.valueOf(this.proxy) + ",organizationId=" + String.valueOf(this.organizationId) + ",modelName=" + String.valueOf(this.modelName) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OpenAiStreamingChatModelConfig)) {
                    return false;
                }
                OpenAiStreamingChatModelConfig other = (OpenAiStreamingChatModelConfig)o;
                return Objects.equals(this.temperature, other.temperature()) && Objects.equals(this.topP, other.topP()) && Objects.equals(this.stop, other.stop()) && Objects.equals(this.maxTokens, other.maxTokens()) && Objects.equals(this.maxCompletionTokens, other.maxCompletionTokens()) && Objects.equals(this.presencePenalty, other.presencePenalty()) && Objects.equals(this.frequencyPenalty, other.frequencyPenalty()) && Objects.equals(this.logitBias, other.logitBias()) && Objects.equals(this.responseFormat, other.responseFormat()) && Objects.equals(this.seed, other.seed()) && Objects.equals(this.user, other.user()) && Objects.equals(this.strictTools, other.strictTools()) && Objects.equals(this.parallelToolCalls, other.parallelToolCalls()) && Objects.equals(this.tokenizer, other.tokenizer()) && this.enabled == other.enabled() && Objects.equals(this.baseUrl, other.baseUrl()) && Objects.equals(this.apiKey, other.apiKey()) && Objects.equals(this.logRequests, other.logRequests()) && Objects.equals(this.logResponses, other.logResponses()) && Objects.equals(this.customHeaders, other.customHeaders()) && Objects.equals(this.timeout, other.timeout()) && Objects.equals(this.proxy, other.proxy()) && Objects.equals(this.organizationId, other.organizationId()) && Objects.equals(this.modelName, other.modelName());
            }

            public int hashCode() {
                return Objects.hash(this.temperature, this.topP, this.stop, this.maxTokens, this.maxCompletionTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.responseFormat, this.seed, this.user, this.strictTools, this.parallelToolCalls, this.tokenizer, this.enabled, this.baseUrl, this.apiKey, this.logRequests, this.logResponses, this.customHeaders, this.timeout, this.proxy, this.organizationId, this.modelName);
            }
        }
    }
}

