/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.Wrapper;
import io.helidon.metrics.providers.micrometer.MCounter;
import io.helidon.metrics.providers.micrometer.MDistributionSummary;
import io.helidon.metrics.providers.micrometer.MFunctionalCounter;
import io.helidon.metrics.providers.micrometer.MGauge;
import io.helidon.metrics.providers.micrometer.MTag;
import io.helidon.metrics.providers.micrometer.MTimer;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.TreeMap;

class MMeter<M extends Meter>
implements io.helidon.metrics.api.Meter {
    private static final String DEFAULT_SCOPE = "application";
    private final M delegate;
    private final Meter.Id id;
    private String scope;
    private boolean isDeleted = false;

    protected MMeter(Meter.Id id, M delegate, Builder<?, ?, ?, ?> builder) {
        this(id, delegate, builder.scope);
    }

    protected MMeter(Meter.Id id, M delegate, Optional<String> scope) {
        this(id, delegate, (String)scope.orElse(null));
    }

    protected MMeter(Meter.Id id, M delegate) {
        this(id, delegate, (String)null);
    }

    private MMeter(Meter.Id id, M delegate, String scope) {
        this.delegate = delegate;
        this.id = id;
        this.scope = scope;
    }

    static <M extends Meter, HM extends MMeter<M>> HM create(Meter.Id id, Meter meter, Optional<String> scope) {
        if (meter instanceof Counter) {
            Counter counter = (Counter)meter;
            return (HM)MCounter.create(id, counter, scope);
        }
        if (meter instanceof DistributionSummary) {
            DistributionSummary summary = (DistributionSummary)meter;
            return (HM)MDistributionSummary.create(id, summary, scope);
        }
        if (meter instanceof Gauge) {
            Gauge gauge = (Gauge)meter;
            return (HM)MGauge.create(id, gauge, scope);
        }
        if (meter instanceof FunctionCounter) {
            FunctionCounter fCounter = (FunctionCounter)meter;
            return (HM)MFunctionalCounter.create(id, fCounter, scope);
        }
        if (meter instanceof Timer) {
            Timer timer = (Timer)meter;
            return (HM)MTimer.create(id, timer, scope);
        }
        return null;
    }

    public Meter.Id id() {
        return this.id;
    }

    public Optional<String> baseUnit() {
        return Optional.ofNullable(this.delegate.getId().getBaseUnit());
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.delegate.getId().getDescription());
    }

    public Meter.Type type() {
        return Meter.Type.valueOf((String)this.delegate.getId().getType().name());
    }

    public Optional<String> scope() {
        return Optional.ofNullable(this.scope);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MMeter mMeter = (MMeter)o;
        return Objects.equals(this.delegate, mMeter.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public <R> R unwrap(Class<? extends R> c) {
        return c.cast(this.delegate);
    }

    protected M delegate() {
        return this.delegate;
    }

    protected void scope(String scope) {
        this.scope = scope;
    }

    protected boolean isDeleted() {
        return this.isDeleted;
    }

    protected void markAsDeleted() {
        this.isDeleted = true;
    }

    protected StringJoiner stringJoiner() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("id=" + String.valueOf(this.id)).add("scope='" + (this.scope == null ? "" : this.scope) + "'");
    }

    static abstract class Builder<B, M extends Meter, HB extends Builder<B, M, HB, HM>, HM extends MMeter<M>>
    implements Wrapper {
        private final String name;
        private final B delegate;
        private final Map<String, String> tags = new TreeMap<String, String>();
        private String scope;
        private String description;
        private String baseUnit;

        protected Builder(String name, B delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        HB from(Meter.Builder<?, ?> neutralBuilder) {
            neutralBuilder.description().ifPresent(this::description);
            neutralBuilder.baseUnit().ifPresent(this::baseUnit);
            neutralBuilder.scope().ifPresent(this::scope);
            neutralBuilder.tags().forEach((key, value) -> this.addTag(MTag.of(key, value)));
            return this.identity();
        }

        public HB tags(Iterable<io.helidon.metrics.api.Tag> tags) {
            this.tags.clear();
            tags.forEach(tag -> this.tags.put(tag.key(), tag.value()));
            return this.delegateTags(MTag.tags(tags));
        }

        public HB addTag(io.helidon.metrics.api.Tag tag) {
            this.tags.put(tag.key(), tag.value());
            return this.delegateTag(tag.key(), tag.value());
        }

        public HB description(String description) {
            this.description = description;
            if (description != null && !description.isBlank()) {
                this.delegateDescription(description);
            }
            return this.identity();
        }

        public HB baseUnit(String baseUnit) {
            this.baseUnit = baseUnit;
            if (baseUnit != null && !baseUnit.isBlank()) {
                this.delegateBaseUnit(baseUnit);
            }
            return this.identity();
        }

        public HB scope(String scope) {
            this.scope = scope;
            return this.identity();
        }

        public HB identity() {
            return (HB)this;
        }

        public String name() {
            return this.name;
        }

        public Map<String, String> tagsMap() {
            return new TreeMap<String, String>(this.tags);
        }

        public Optional<String> scope() {
            return Optional.ofNullable(this.scope);
        }

        public Optional<String> description() {
            return Optional.ofNullable(this.description);
        }

        public Optional<String> baseUnit() {
            return Optional.ofNullable(this.baseUnit);
        }

        public Map<String, String> tags() {
            return new TreeMap<String, String>(this.tags);
        }

        public <R> R unwrap(Class<? extends R> c) {
            return c.cast(this.delegate);
        }

        protected B delegate() {
            return this.delegate;
        }

        protected Meter.Id id() {
            return PlainId.create(this);
        }

        protected abstract HB delegateTags(Iterable<Tag> var1);

        protected abstract HB delegateTag(String var1, String var2);

        protected abstract HB delegateDescription(String var1);

        protected abstract HB delegateBaseUnit(String var1);

        protected abstract HM build(Meter.Id var1, M var2);

        protected abstract Class<? extends io.helidon.metrics.api.Meter> meterType();
    }

    static class PlainId
    implements Meter.Id {
        private final String name;
        private final List<io.helidon.metrics.api.Tag> tags;

        private PlainId(String name, Iterable<io.helidon.metrics.api.Tag> neutralTags) {
            this.name = name;
            this.tags = new ArrayList<io.helidon.metrics.api.Tag>();
            neutralTags.forEach(this.tags::add);
        }

        private PlainId(Builder<?, ?, ?, ?> builder) {
            this.name = builder.name;
            this.tags = builder.tags.entrySet().stream().map(entry -> io.helidon.metrics.api.Tag.create((String)((String)entry.getKey()), (String)((String)entry.getValue()))).toList();
        }

        static PlainId create(Builder<?, ?, ?, ?> builder) {
            return new PlainId(builder);
        }

        static PlainId create(String name, Iterable<io.helidon.metrics.api.Tag> promTags) {
            return new PlainId(name, promTags);
        }

        public String name() {
            return this.name;
        }

        public Iterable<io.helidon.metrics.api.Tag> tags() {
            return this.tags;
        }

        public String toString() {
            return new StringJoiner(", ", PlainId.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("tags=" + String.valueOf(this.tags)).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PlainId)) {
                return false;
            }
            PlainId plainId = (PlainId)o;
            return Objects.equals(this.name, plainId.name) && Objects.equals(this.tags, plainId.tags);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.tags);
        }

        private static io.helidon.metrics.api.Tag tag(Tag tag) {
            return io.helidon.metrics.api.Tag.create((String)tag.getKey(), (String)tag.getValue());
        }
    }

    static class Id
    implements Meter.Id {
        private final Meter.Id delegate;

        private Id(Meter.Id delegate) {
            this.delegate = delegate;
        }

        static Id create(Meter.Id id) {
            return new Id(id);
        }

        public String name() {
            return this.delegate.getName();
        }

        public String toString() {
            return String.format("ID[name=%s,tagsMap=[%s]]", this.delegate.getName(), this.delegate.getTags());
        }

        public Iterable<io.helidon.metrics.api.Tag> tags() {
            return MTag.neutralTags(this.delegate.getTags());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return Objects.equals(this.delegate, id.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }
    }
}

