/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.common.config.Config;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.providers.micrometer.MicrometerMetricsFactory;
import io.helidon.metrics.providers.micrometer.SystemTagsMeterFilterManager;
import io.helidon.metrics.spi.MetersProvider;
import io.helidon.metrics.spi.MetricsFactoryProvider;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MicrometerMetricsFactoryProvider
implements MetricsFactoryProvider {
    private final List<MicrometerMetricsFactory> metricsFactories = new ArrayList<MicrometerMetricsFactory>();

    public MicrometerMetricsFactoryProvider() {
        this.observeGlobalRegistry();
        this.addSystemTagsFilter();
    }

    public MetricsFactory create(Config rootConfig, MetricsConfig metricsConfig, Collection<MetersProvider> metersProviders) {
        return this.save(MicrometerMetricsFactory.create(rootConfig, metricsConfig, metersProviders));
    }

    public void close() {
        this.metricsFactories.forEach(MetricsFactory::close);
        this.metricsFactories.clear();
        List meters = List.copyOf(Metrics.globalRegistry.getMeters());
        meters.forEach(arg_0 -> ((CompositeMeterRegistry)Metrics.globalRegistry).remove(arg_0));
    }

    private MicrometerMetricsFactory save(MicrometerMetricsFactory metricsFactory) {
        this.metricsFactories.add(metricsFactory);
        return metricsFactory;
    }

    private void onMeterAdded(Meter meter) {
        this.metricsFactories.forEach(mf -> mf.onMeterAdded(meter));
    }

    private void onMeterRemoved(Meter meter) {
        this.metricsFactories.forEach(mf -> mf.onMeterRemoved(meter));
    }

    private void observeGlobalRegistry() {
        Metrics.globalRegistry.config().onMeterAdded(this::onMeterAdded);
        Metrics.globalRegistry.config().onMeterRemoved(this::onMeterRemoved);
    }

    private void addSystemTagsFilter() {
        Metrics.globalRegistry.config().meterFilter(MeterFilter.commonTags(SystemTagsMeterFilterManager.instance().tags()));
    }
}

