/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.faulttolerance;

import io.helidon.faulttolerance.BulkheadException;
import io.helidon.faulttolerance.CircuitBreakerOpenException;
import io.helidon.faulttolerance.RetryTimeoutException;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;

class ThrowableMapper {
    private ThrowableMapper() {
    }

    static Throwable map(Throwable t) {
        if (t instanceof ExecutionException) {
            t = t.getCause();
        }
        if (t instanceof CircuitBreakerOpenException) {
            return new org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException(t.getMessage(), t.getCause());
        }
        if (t instanceof BulkheadException) {
            return new org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException(t.getMessage(), t.getCause());
        }
        if (t instanceof RetryTimeoutException) {
            return t;
        }
        if (t instanceof io.helidon.faulttolerance.TimeoutException || t instanceof InterruptedException) {
            return new TimeoutException(t.getMessage(), t.getCause());
        }
        return t;
    }

    static Set<Class<? extends Throwable>> mapTypes(Class<? extends Throwable>[] types) {
        if (types.length == 0) {
            return Set.of();
        }
        Class<? extends Throwable>[] result = Arrays.copyOf(types, types.length);
        for (int i = 0; i < types.length; ++i) {
            Class<? extends Throwable> t = types[i];
            result[i] = t == org.eclipse.microprofile.faulttolerance.exceptions.BulkheadException.class ? BulkheadException.class : (t == org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException.class ? CircuitBreakerOpenException.class : (t == TimeoutException.class ? io.helidon.faulttolerance.TimeoutException.class : t));
        }
        return Set.of(result);
    }
}

