/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.testing;

import io.helidon.common.GenericType;
import io.helidon.common.LazyValue;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.MissingValueException;
import io.helidon.config.spi.ConfigMapper;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.LazyConfigSource;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

abstract class HelidonTestConfigDelegate
implements org.eclipse.microprofile.config.Config,
Config {
    private final LazyValue<Config> hdelegate = LazyValue.create(this::delegate0);
    private final Map<org.eclipse.microprofile.config.Config, List<String>> cache = new HashMap<org.eclipse.microprofile.config.Config, List<String>>();

    HelidonTestConfigDelegate() {
    }

    abstract org.eclipse.microprofile.config.Config delegate();

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        return (T)this.delegate().getValue(propertyName, propertyType);
    }

    public ConfigValue getConfigValue(String propertyName) {
        return this.delegate().getConfigValue(propertyName);
    }

    public <T> List<T> getValues(String propertyName, Class<T> propertyType) {
        return this.delegate().getValues(propertyName, propertyType);
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        return this.delegate().getOptionalValue(propertyName, propertyType);
    }

    public <T> Optional<List<T>> getOptionalValues(String propertyName, Class<T> propertyType) {
        return this.delegate().getOptionalValues(propertyName, propertyType);
    }

    public Iterable<String> getPropertyNames() {
        return this.delegate().getPropertyNames();
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.delegate().getConfigSources();
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
        return this.delegate().getConverter(forType);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.delegate().unwrap(type);
    }

    public Instant timestamp() {
        return ((Config)this.hdelegate.get()).timestamp();
    }

    public Config.Key key() {
        return ((Config)this.hdelegate.get()).key();
    }

    public Config root() {
        return ((Config)this.hdelegate.get()).root();
    }

    public Config get(Config.Key key) {
        return ((Config)this.hdelegate.get()).get(key);
    }

    public Config detach() {
        return ((Config)this.hdelegate.get()).detach();
    }

    public Config.Type type() {
        return ((Config)this.hdelegate.get()).type();
    }

    public boolean hasValue() {
        return ((Config)this.hdelegate.get()).hasValue();
    }

    public Stream<Config> traverse(Predicate<Config> predicate) {
        return ((Config)this.hdelegate.get()).traverse(predicate);
    }

    public <T> T convert(Class<T> type, String value) throws ConfigMappingException {
        return (T)((Config)this.hdelegate.get()).convert(type, value);
    }

    public ConfigMapper mapper() {
        return ((Config)this.hdelegate.get()).mapper();
    }

    public <T> io.helidon.config.ConfigValue<T> as(GenericType<T> genericType) {
        return ((Config)this.hdelegate.get()).as(genericType);
    }

    public <T> io.helidon.config.ConfigValue<T> as(Class<T> type) {
        return ((Config)this.hdelegate.get()).as(type);
    }

    public <T> io.helidon.config.ConfigValue<T> as(Function<Config, T> mapper) {
        return ((Config)this.hdelegate.get()).as(mapper);
    }

    public <T> io.helidon.config.ConfigValue<List<T>> asList(Class<T> type) throws ConfigMappingException {
        return ((Config)this.hdelegate.get()).asList(type);
    }

    public <T> io.helidon.config.ConfigValue<List<T>> asList(Function<Config, T> mapper) throws ConfigMappingException {
        return ((Config)this.hdelegate.get()).asList(mapper);
    }

    public io.helidon.config.ConfigValue<List<Config>> asNodeList() throws ConfigMappingException {
        return ((Config)this.hdelegate.get()).asNodeList();
    }

    public io.helidon.config.ConfigValue<Map<String, String>> asMap() throws MissingValueException {
        return ((Config)this.hdelegate.get()).asMap();
    }

    void refresh() {
        org.eclipse.microprofile.config.Config delegate = this.delegate();
        if (delegate != null) {
            this.cache.computeIfPresent(delegate, (k, v) -> {
                ArrayList<String> names = new ArrayList<String>();
                for (String name : k.getPropertyNames()) {
                    names.add(name);
                }
                return names;
            });
        }
    }

    private List<String> propertyNames(org.eclipse.microprofile.config.Config config) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : config.getPropertyNames()) {
            names.add(name);
        }
        return names;
    }

    private Config delegate0() {
        return Config.just((Supplier[])new Supplier[]{(LazyConfigSource & io.helidon.config.spi.ConfigSource)key -> {
            org.eclipse.microprofile.config.Config delegate = this.delegate();
            if (delegate != null) {
                String value = delegate.getConfigValue(key).getValue();
                if (value != null) {
                    return Optional.of(ConfigNode.ValueNode.create((String)value));
                }
                List propertyNames = this.cache.computeIfAbsent(delegate, this::propertyNames);
                ConfigNode.ObjectNode.Builder builder = ConfigNode.ObjectNode.builder();
                boolean hasEntries = false;
                for (String name : propertyNames) {
                    if (!name.startsWith(key + ".")) continue;
                    String k = name.substring(key.length() + 1);
                    String v = delegate.getConfigValue(name).getValue();
                    builder.addValue(k, v);
                    hasEntries = true;
                }
                if (hasEntries) {
                    return Optional.of(builder.build());
                }
            }
            return Optional.empty();
        }});
    }
}

