/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.jwt;

import io.helidon.common.Errors;
import io.helidon.security.jwt.AudienceValidator;
import io.helidon.security.jwt.ClaimValidator;
import io.helidon.security.jwt.CriticalValidator;
import io.helidon.security.jwt.ExpirationValidator;
import io.helidon.security.jwt.FieldValidator;
import io.helidon.security.jwt.IssueTimeValidator;
import io.helidon.security.jwt.Jwt;
import io.helidon.security.jwt.JwtScope;
import io.helidon.security.jwt.JwtValidators;
import io.helidon.security.jwt.MaxTokenAgeValidator;
import io.helidon.security.jwt.NotBeforeValidator;
import io.helidon.security.jwt.UserPrincipalValidator;
import io.helidon.security.jwt.Validator;
import io.helidon.security.jwt.ValidatorWrapper;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public interface JwtValidator {
    public static Builder builder() {
        return new Builder();
    }

    public Errors validate(Jwt var1);

    public static final class Builder
    implements io.helidon.common.Builder<Builder, JwtValidator> {
        private final List<ClaimValidator> claimValidators = new ArrayList<ClaimValidator>();

        private Builder() {
        }

        public JwtValidator build() {
            return new JwtValidators(this);
        }

        public Builder addClaimValidator(ClaimValidator claimValidator) {
            this.claimValidators.add(claimValidator);
            return this;
        }

        public Builder addValidator(Validator<Jwt> validator, String ... claims) {
            return this.addValidator(JwtScope.PAYLOAD, validator, claims);
        }

        public Builder addValidator(JwtScope scope, Validator<Jwt> validator, String ... claims) {
            Objects.requireNonNull(scope);
            Objects.requireNonNull(validator);
            this.claimValidators.add(((ValidatorWrapper.Builder)((ValidatorWrapper.Builder)ValidatorWrapper.builder().scope(scope)).validator(validator).claims(Set.of(claims))).build());
            return this;
        }

        public Builder addHeaderFieldValidator(String claimKey, String fieldName, String expectedValue) {
            Objects.requireNonNull(claimKey);
            Objects.requireNonNull(fieldName);
            Objects.requireNonNull(expectedValue);
            this.claimValidators.add(FieldValidator.builder().scope(JwtScope.HEADER).claimKey(claimKey).name(fieldName).expectedValue(expectedValue).build());
            return this;
        }

        public Builder addPayloadFieldValidator(String claimKey, String fieldName, String expectedValue) {
            Objects.requireNonNull(claimKey);
            Objects.requireNonNull(fieldName);
            Objects.requireNonNull(expectedValue);
            this.claimValidators.add(FieldValidator.builder().claimKey(claimKey).name(fieldName).expectedValue(expectedValue).build());
            return this;
        }

        public Builder addFieldValidator(Consumer<FieldValidator.Builder> builderConsumer) {
            Objects.requireNonNull(builderConsumer);
            FieldValidator.Builder builder = FieldValidator.builder();
            builderConsumer.accept(builder);
            this.claimValidators.add(builder.build());
            return this;
        }

        public Builder addIssuerValidator(String expectedIssuer) {
            return this.addIssuerValidator(expectedIssuer, true);
        }

        public Builder addIssuerValidator(String expectedIssuer, boolean mandatory) {
            Objects.requireNonNull(expectedIssuer);
            this.claimValidators.add(((FieldValidator.Builder)FieldValidator.builder().fieldAccessor(Jwt::issuer).name("Issuer").expectedValue(expectedIssuer).mandatory(mandatory)).build());
            return this;
        }

        public Builder addDefaultTimeValidators() {
            this.addExpirationValidator();
            this.addIssueTimeValidator();
            this.addNotBeforeValidator();
            return this;
        }

        public Builder addDefaultTimeValidators(Instant now, Duration allowedTimeSkew, boolean mandatory) {
            Objects.requireNonNull(now);
            Objects.requireNonNull(allowedTimeSkew);
            this.addExpirationValidator(builder -> ((ExpirationValidator.Builder)((ExpirationValidator.Builder)builder.now(now)).allowedTimeSkew(allowedTimeSkew)).mandatory(mandatory));
            this.addIssueTimeValidator(builder -> ((IssueTimeValidator.Builder)((IssueTimeValidator.Builder)builder.now(now)).allowedTimeSkew(allowedTimeSkew)).mandatory(mandatory));
            this.addNotBeforeValidator(builder -> ((NotBeforeValidator.Builder)((NotBeforeValidator.Builder)builder.now(now)).allowedTimeSkew(allowedTimeSkew)).mandatory(mandatory));
            return this;
        }

        public Builder addExpirationValidator() {
            this.claimValidators.add(ExpirationValidator.builder().build());
            return this;
        }

        public Builder addExpirationValidator(Consumer<ExpirationValidator.Builder> builderConsumer) {
            Objects.requireNonNull(builderConsumer);
            ExpirationValidator.Builder builder = ExpirationValidator.builder();
            builderConsumer.accept(builder);
            this.claimValidators.add(builder.build());
            return this;
        }

        public Builder addNotBeforeValidator() {
            this.claimValidators.add(NotBeforeValidator.builder().build());
            return this;
        }

        public Builder addNotBeforeValidator(Consumer<NotBeforeValidator.Builder> builderConsumer) {
            Objects.requireNonNull(builderConsumer);
            NotBeforeValidator.Builder builder = NotBeforeValidator.builder();
            builderConsumer.accept(builder);
            this.claimValidators.add(builder.build());
            return this;
        }

        public Builder addIssueTimeValidator() {
            this.claimValidators.add(IssueTimeValidator.builder().build());
            return this;
        }

        public Builder addIssueTimeValidator(Consumer<IssueTimeValidator.Builder> builderConsumer) {
            Objects.requireNonNull(builderConsumer);
            IssueTimeValidator.Builder builder = IssueTimeValidator.builder();
            builderConsumer.accept(builder);
            this.claimValidators.add(builder.build());
            return this;
        }

        public Builder addCriticalValidator() {
            this.claimValidators.add(new CriticalValidator());
            return this;
        }

        public Builder addUserPrincipalValidator() {
            this.claimValidators.add(UserPrincipalValidator.builder().build());
            return this;
        }

        public Builder addUserPrincipalValidator(Consumer<UserPrincipalValidator.Builder> builderConsumer) {
            Objects.requireNonNull(builderConsumer);
            UserPrincipalValidator.Builder builder = UserPrincipalValidator.builder();
            builderConsumer.accept(builder);
            this.claimValidators.add(builder.build());
            return this;
        }

        public Builder addMaxTokenAgeValidator(Duration expectedMaxTokenAge) {
            Objects.requireNonNull(expectedMaxTokenAge);
            this.claimValidators.add(MaxTokenAgeValidator.builder().expectedMaxTokenAge(expectedMaxTokenAge).build());
            return this;
        }

        public Builder addMaxTokenAgeValidator(Consumer<MaxTokenAgeValidator.Builder> builderConsumer) {
            Objects.requireNonNull(builderConsumer);
            MaxTokenAgeValidator.Builder builder = MaxTokenAgeValidator.builder();
            builderConsumer.accept(builder);
            this.claimValidators.add(builder.build());
            return this;
        }

        public Builder addAudienceValidator(String expectedAudience) {
            Objects.requireNonNull(expectedAudience);
            this.claimValidators.add(AudienceValidator.builder().addExpectedAudience(expectedAudience).build());
            return this;
        }

        public Builder addAudienceValidator(Set<String> expectedAudience) {
            Objects.requireNonNull(expectedAudience);
            this.claimValidators.add(AudienceValidator.builder().expectedAudience(expectedAudience).build());
            return this;
        }

        public Builder addAudienceValidator(Consumer<AudienceValidator.Builder> builderConsumer) {
            Objects.requireNonNull(builderConsumer);
            AudienceValidator.Builder builder = AudienceValidator.builder();
            builderConsumer.accept(builder);
            this.claimValidators.add(builder.build());
            return this;
        }

        public Builder clearValidators() {
            this.claimValidators.clear();
            return this;
        }

        List<ClaimValidator> claimValidators() {
            return this.claimValidators;
        }
    }
}

