/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.providers.oidc.common;

import io.helidon.common.Errors;
import io.helidon.common.config.Config;
import io.helidon.common.socket.SocketOptions;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaContextConfig;
import io.helidon.http.media.jsonp.JsonpSupport;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.tracing.WebClientTracing;
import java.time.Duration;

final class OidcUtil {
    private static final System.Logger LOGGER = System.getLogger(OidcUtil.class.getName());

    private OidcUtil() {
    }

    static String fixServerType(String serverType) {
        if (serverType != null) {
            if (!"idcs".equals(serverType) && !"@default".equals(serverType)) {
                LOGGER.log(System.Logger.Level.WARNING, "OIDC server-type is configured to " + serverType + ", currently only \"idcs\", and \"@default\" are supported");
                return "@default";
            }
        } else {
            return "@default";
        }
        return serverType;
    }

    static WebClientConfig.Builder webClientBaseBuilder(String proxyProtocol, String proxyHost, int proxyPort, boolean relativeUris, Duration clientTimeout) {
        WebClientConfig.Builder webClientBuilder = (WebClientConfig.Builder)((WebClientConfig.Builder)((WebClientConfig.Builder)((WebClientConfig.Builder)WebClient.builder().addService(WebClientTracing.create())).servicesDiscoverServices(false)).mediaContext(((MediaContextConfig.Builder)((MediaContextConfig.Builder)MediaContext.builder().mediaSupportsDiscoverServices(false)).addMediaSupport(JsonpSupport.create((Config)Config.empty()))).build())).socketOptions(((SocketOptions.Builder)((SocketOptions.Builder)SocketOptions.builder().connectTimeout(clientTimeout)).readTimeout(clientTimeout)).build());
        if (proxyHost != null) {
            Proxy.ProxyType proxyType = Proxy.ProxyType.valueOf((String)proxyProtocol.toUpperCase());
            ((WebClientConfig.Builder)webClientBuilder.proxy(Proxy.builder().type(proxyType).host(proxyHost).port(proxyPort).build())).relativeUris(relativeUris);
        }
        return webClientBuilder;
    }

    static void validateExists(Errors.Collector collector, Object value, String name, String configKey) {
        if (value == null) {
            collector.fatal(name + " must be configured (\"" + configKey + "\" key in config)");
        }
    }
}

