/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.ElementInfoPredicates;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import io.helidon.service.codegen.CoreDependency;
import io.helidon.service.codegen.CoreFactoryType;
import io.helidon.service.codegen.CoreTypeConstants;
import io.helidon.service.codegen.RegistryCodegenContext;
import io.helidon.service.codegen.RegistryRoundContext;
import io.helidon.service.codegen.ServiceCodegenTypes;
import io.helidon.service.codegen.ServiceContracts;
import io.helidon.service.codegen.ServiceSuperType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class CoreService {
    private static final TypedElementInfo DEFAULT_CONSTRUCTOR = ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().typeName(TypeNames.OBJECT)).accessModifier(AccessModifier.PUBLIC)).kind(ElementKind.CONSTRUCTOR)).build();
    private final boolean isAbstract;
    private final CoreFactoryType factoryType;
    private final TypeName serviceType;
    private final TypeName descriptorType;
    private final ServiceSuperType superType;
    private final List<CoreDependency> dependencies;
    private final CoreTypeConstants constants;
    private final Set<ResolvedType> contracts;
    private final Set<ResolvedType> factoryContracts;

    CoreService(boolean isAbstract, CoreFactoryType factoryType, TypeName serviceType, TypeName descriptorType, ServiceSuperType superType, List<CoreDependency> dependencies, CoreTypeConstants constants, Set<ResolvedType> contracts, Set<ResolvedType> factoryContracts) {
        this.isAbstract = isAbstract;
        this.factoryType = factoryType;
        this.serviceType = serviceType;
        this.descriptorType = descriptorType;
        this.superType = superType;
        this.dependencies = dependencies;
        this.constants = constants;
        this.contracts = contracts;
        this.factoryContracts = factoryContracts;
    }

    static CoreService create(RegistryCodegenContext ctx, RegistryRoundContext roundContext, TypeInfo serviceInfo, Collection<TypeInfo> allServices) {
        TypeName serviceType = serviceInfo.typeName();
        TypeName descriptorType = ctx.descriptorType(serviceType);
        HashSet<ResolvedType> directContracts = new HashSet<ResolvedType>();
        HashSet<ResolvedType> providedContracts = new HashSet<ResolvedType>();
        CoreFactoryType factoryType = CoreFactoryType.SERVICE;
        ServiceContracts serviceContracts = roundContext.serviceContracts(serviceInfo);
        List typeInfos = serviceInfo.interfaceTypeInfo();
        HashMap<TypeName, TypeInfo> implementedInterfaceTypes = new HashMap<TypeName, TypeInfo>();
        typeInfos.forEach(it -> implementedInterfaceTypes.put(it.typeName(), (TypeInfo)it));
        ServiceContracts.FactoryAnalysis response = serviceContracts.analyseFactory(TypeNames.SUPPLIER);
        if (response.valid()) {
            factoryType = CoreFactoryType.SUPPLIER;
            directContracts.add(ResolvedType.create((TypeName)response.factoryType()));
            providedContracts.addAll(response.providedContracts());
            implementedInterfaceTypes.remove(TypeNames.SUPPLIER);
        }
        HashSet processedDirectContracts = new HashSet();
        implementedInterfaceTypes.forEach((type, typeInfo) -> serviceContracts.addContracts((Set<ResolvedType>)directContracts, processedDirectContracts, (TypeInfo)typeInfo));
        HashSet<ResolvedType> factoryContracts = factoryType == CoreFactoryType.SUPPLIER ? directContracts : Set.of();
        HashSet<ResolvedType> contracts = factoryType == CoreFactoryType.SUPPLIER ? providedContracts : directContracts;
        DependencyResult dependencyResult = CoreService.gatherDependencies(ctx, serviceInfo);
        ServiceSuperType superType = CoreService.superType(ctx, serviceInfo, allServices);
        return new CoreService(CoreService.isAbstract(serviceInfo), factoryType, serviceType, descriptorType, superType, dependencyResult.result(), dependencyResult.constants(), contracts, factoryContracts);
    }

    boolean isAbstract() {
        return this.isAbstract;
    }

    CoreFactoryType factoryType() {
        return this.factoryType;
    }

    TypeName serviceType() {
        return this.serviceType;
    }

    TypeName descriptorType() {
        return this.descriptorType;
    }

    ServiceSuperType superType() {
        return this.superType;
    }

    List<CoreDependency> dependencies() {
        return this.dependencies;
    }

    Set<ResolvedType> contracts() {
        return this.contracts;
    }

    Set<ResolvedType> factoryContracts() {
        return this.factoryContracts;
    }

    CoreTypeConstants constants() {
        return this.constants;
    }

    private static ServiceSuperType superType(RegistryCodegenContext ctx, TypeInfo serviceInfo, Collection<TypeInfo> services) {
        Optional maybeSuperType = serviceInfo.superTypeInfo();
        if (maybeSuperType.isEmpty()) {
            return ServiceSuperType.create();
        }
        TypeInfo superType = (TypeInfo)maybeSuperType.get();
        TypeName expectedSuperDescriptor = ctx.descriptorType(superType.typeName());
        TypeName superTypeToExtend = ((TypeName.Builder)TypeName.builder((TypeName)expectedSuperDescriptor).addTypeArgument(TypeName.create((String)"T"))).build();
        boolean isCore = superType.hasAnnotation(ServiceCodegenTypes.SERVICE_ANNOTATION_PROVIDER);
        if (!isCore) {
            throw new CodegenException("Service annotated with @Service.Provider extends invalid supertype, the super type must also be a @Service.Provider. Type: " + serviceInfo.typeName().fqName() + ", super type: " + superType.typeName().fqName(), serviceInfo.originatingElementValue());
        }
        for (TypeInfo service : services) {
            if (!service.typeName().equals((Object)superType.typeName())) continue;
            return ServiceSuperType.create(service, superTypeToExtend);
        }
        return ctx.typeInfo(expectedSuperDescriptor).map(it -> ServiceSuperType.create(superType, superTypeToExtend)).orElseGet(ServiceSuperType::create);
    }

    private static DependencyResult gatherDependencies(RegistryCodegenContext ctx, TypeInfo serviceInfo) {
        TypedElementInfo constructor = CoreService.constructor(serviceInfo);
        AtomicInteger dependencyIndex = new AtomicInteger();
        ArrayList<CoreDependency> result = new ArrayList<CoreDependency>();
        CoreTypeConstants constants = new CoreTypeConstants();
        for (TypedElementInfo param : constructor.parameterArguments()) {
            result.add(CoreDependency.create(ctx, constructor, param, constants, dependencyIndex.getAndIncrement()));
        }
        return new DependencyResult(result, constants);
    }

    private static TypedElementInfo constructor(TypeInfo serviceInfo) {
        List allConstructors = serviceInfo.elementInfo().stream().filter(ElementInfoPredicates::isConstructor).collect(Collectors.toUnmodifiableList());
        if (allConstructors.isEmpty()) {
            return DEFAULT_CONSTRUCTOR;
        }
        List nonPrivateConstructors = allConstructors.stream().filter(Predicate.not(ElementInfoPredicates::isPrivate)).collect(Collectors.toUnmodifiableList());
        if (nonPrivateConstructors.isEmpty()) {
            throw new CodegenException("Service does not contain any non-private constructor", serviceInfo.originatingElementValue());
        }
        if (allConstructors.size() > 1) {
            throw new CodegenException("Service contains more than one non-private constructor", serviceInfo.originatingElementValue());
        }
        return (TypedElementInfo)allConstructors.getFirst();
    }

    private static boolean isAbstract(TypeInfo serviceInfo) {
        return serviceInfo.elementModifiers().contains(Modifier.ABSTRACT) && serviceInfo.kind() == ElementKind.CLASS;
    }

    private record DependencyResult(List<CoreDependency> result, CoreTypeConstants constants) {
    }
}

