/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http1.Http1CallChainBase;
import io.helidon.webclient.http1.Http1ClientImpl;
import io.helidon.webclient.http1.Http1ClientRequestImpl;
import java.util.concurrent.CompletableFuture;

class Http1CallEntityChain
extends Http1CallChainBase {
    private final CompletableFuture<WebClientServiceRequest> whenSent;
    private final byte[] entity;

    Http1CallEntityChain(Http1ClientImpl http1Client, Http1ClientRequestImpl request, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete, byte[] entity) {
        super(http1Client, request, whenComplete);
        this.whenSent = whenSent;
        this.entity = entity;
    }

    @Override
    public WebClientServiceResponse doProceed(ClientConnection connection, WebClientServiceRequest serviceRequest, ClientRequestHeaders headers, DataWriter writer, DataReader reader, BufferData writeBuffer) {
        headers.set(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (int)this.entity.length));
        Http1CallEntityChain.writeHeaders((Headers)headers, writeBuffer, this.protocolConfig().validateRequestHeaders());
        this.whenSent.complete(serviceRequest);
        if (this.entity.length > 0) {
            writeBuffer.write(this.entity);
        }
        writer.write(writeBuffer);
        return this.readResponse(serviceRequest, connection, reader);
    }
}

