/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.lang.Nullable;
import io.micrometer.tracing.http.HttpServerRequest;
import io.micrometer.tracing.http.HttpServerResponse;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.net.URI;
import java.util.Collections;
import java.util.List;

public class DefaultHttpServerAttributesExtractor
implements HttpServerAttributesGetter<HttpServerRequest, HttpServerResponse> {
    @Nullable
    public String getFlavor(HttpServerRequest httpServerRequest) {
        return null;
    }

    @Nullable
    public String getTarget(HttpServerRequest httpServerRequest) {
        URI uri = this.toUri(httpServerRequest);
        if (uri == null) {
            return null;
        }
        return uri.getPath() + this.queryPart(uri);
    }

    private URI toUri(HttpServerRequest request) {
        String url = request.url();
        return url == null ? null : URI.create(url);
    }

    private String queryPart(URI uri) {
        String query = uri.getQuery();
        return query != null ? "?" + query : "";
    }

    @Nullable
    public String getRoute(HttpServerRequest httpServerRequest) {
        return httpServerRequest.route();
    }

    @Nullable
    public String getScheme(HttpServerRequest httpServerRequest) {
        String url = httpServerRequest.url();
        if (url == null) {
            return null;
        }
        if (url.startsWith("https:")) {
            return "https";
        }
        if (url.startsWith("http:")) {
            return "http";
        }
        return null;
    }

    @Nullable
    public String getMethod(HttpServerRequest httpServerRequest) {
        return httpServerRequest.method();
    }

    public List<String> getRequestHeader(HttpServerRequest httpServerRequest, String name) {
        String value = httpServerRequest.header(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Nullable
    public Integer getStatusCode(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse, Throwable error) {
        return httpServerResponse.statusCode();
    }

    public List<String> getResponseHeader(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse, String name) {
        String value = httpServerResponse.header(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }
}

