/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.otel.bridge;

import io.micrometer.common.util.StringUtils;
import io.micrometer.tracing.Link;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.TraceContext;
import io.micrometer.tracing.otel.bridge.OtelSpan;
import io.micrometer.tracing.otel.bridge.OtelTraceContext;
import io.micrometer.tracing.otel.bridge.SpanFromSpanContext;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class OtelSpanBuilder
implements Span.Builder {
    static final String REMOTE_SERVICE_NAME_KEY = "peer.service";
    private final SpanBuilder delegate;
    private final List<String> annotations = new LinkedList<String>();
    private String name;
    private Throwable error;
    private TraceContext parentTraceContext;

    OtelSpanBuilder(SpanBuilder delegate) {
        this.delegate = delegate;
    }

    static Span.Builder fromOtel(SpanBuilder builder) {
        return new OtelSpanBuilder(builder);
    }

    public Span.Builder setParent(TraceContext context) {
        this.delegate.setParent(OtelTraceContext.toOtelContext(context));
        this.parentTraceContext = context;
        return this;
    }

    public Span.Builder setNoParent() {
        this.delegate.setNoParent();
        return this;
    }

    public Span.Builder name(String name) {
        this.name = name;
        return this;
    }

    public Span.Builder event(String value) {
        this.annotations.add(value);
        return this;
    }

    public Span.Builder tag(String key, String value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span.Builder tag(String key, long value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span.Builder tag(String key, double value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span.Builder tag(String key, boolean value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span.Builder error(Throwable throwable) {
        this.error = throwable;
        return this;
    }

    public Span.Builder kind(Span.Kind spanKind) {
        if (spanKind == null) {
            this.delegate.setSpanKind(SpanKind.INTERNAL);
            return this;
        }
        SpanKind kind = SpanKind.INTERNAL;
        switch (spanKind) {
            case CLIENT: {
                kind = SpanKind.CLIENT;
                break;
            }
            case SERVER: {
                kind = SpanKind.SERVER;
                break;
            }
            case PRODUCER: {
                kind = SpanKind.PRODUCER;
                break;
            }
            case CONSUMER: {
                kind = SpanKind.CONSUMER;
            }
        }
        this.delegate.setSpanKind(kind);
        return this;
    }

    public Span.Builder remoteServiceName(String remoteServiceName) {
        this.delegate.setAttribute(REMOTE_SERVICE_NAME_KEY, remoteServiceName);
        return this;
    }

    public Span.Builder remoteIpAndPort(String ip, int port) {
        this.delegate.setAttribute(SemanticAttributes.NET_SOCK_PEER_ADDR, (Object)ip);
        this.delegate.setAttribute(SemanticAttributes.NET_PEER_PORT, (Object)port);
        return this;
    }

    public Span.Builder startTimestamp(long startTimestamp, TimeUnit unit) {
        this.delegate.setStartTimestamp(startTimestamp, unit);
        return this;
    }

    public Span.Builder addLink(Link link) {
        TraceContext traceContext = link.getTraceContext();
        SpanContext spanContext = ((OtelTraceContext)traceContext).spanContext();
        AttributesBuilder otelAttributes = Attributes.empty().toBuilder();
        for (Map.Entry entry : link.getTags().entrySet()) {
            otelAttributes = otelAttributes.put(OtelSpanBuilder.getAttributeKey((String)entry.getKey(), entry.getValue()), entry.getValue());
        }
        this.delegate.addLink(spanContext, otelAttributes.build());
        return this;
    }

    private static AttributeKey getAttributeKey(String key, Object value) {
        if (value instanceof Double) {
            return AttributeKey.doubleKey((String)key);
        }
        if (value instanceof Long) {
            return AttributeKey.longKey((String)key);
        }
        if (value instanceof Boolean) {
            return AttributeKey.booleanKey((String)key);
        }
        return AttributeKey.stringKey((String)key);
    }

    public Span start() {
        io.opentelemetry.api.trace.Span span = this.delegate.startSpan();
        if (StringUtils.isNotEmpty((String)this.name)) {
            span.updateName(this.name);
        }
        if (this.error != null) {
            span.recordException(this.error);
        }
        this.annotations.forEach(arg_0 -> ((io.opentelemetry.api.trace.Span)span).addEvent(arg_0));
        Span otelSpan = OtelSpan.fromOtel(span);
        if (this.parentTraceContext != null) {
            return OtelSpan.fromOtel(new SpanFromSpanContext(span, span.getSpanContext(), (OtelTraceContext)this.parentTraceContext));
        }
        return otelSpan;
    }
}

