/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.tracing.annotation;

import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.tracing.CurrentTraceContext;
import io.micrometer.tracing.Span;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.annotation.AnnotationSpanDocumentation;
import io.micrometer.tracing.annotation.ContinueSpan;
import io.micrometer.tracing.annotation.MethodInvocationProcessor;
import io.micrometer.tracing.annotation.NewSpanParser;
import io.micrometer.tracing.annotation.SpanAspectMethodInvocation;
import io.micrometer.tracing.annotation.SpanTagAnnotationHandler;
import org.aopalliance.intercept.MethodInvocation;

abstract class AbstractMethodInvocationProcessor
implements MethodInvocationProcessor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractMethodInvocationProcessor.class);
    final NewSpanParser newSpanParser;
    final Tracer tracer;
    final CurrentTraceContext currentTraceContext;
    final SpanTagAnnotationHandler spanTagAnnotationHandler;

    AbstractMethodInvocationProcessor(NewSpanParser newSpanParser, Tracer tracer, CurrentTraceContext currentTraceContext, SpanTagAnnotationHandler spanTagAnnotationHandler) {
        this.newSpanParser = newSpanParser;
        this.tracer = tracer;
        this.currentTraceContext = currentTraceContext;
        this.spanTagAnnotationHandler = spanTagAnnotationHandler;
    }

    void before(MethodInvocation invocation, Span span, String log, boolean hasLog) {
        if (hasLog) {
            this.logEvent(span, String.format(AnnotationSpanDocumentation.Events.BEFORE.getValue(), log));
        }
        if (invocation instanceof SpanAspectMethodInvocation) {
            SpanAspectMethodInvocation spanInvocation = (SpanAspectMethodInvocation)invocation;
            this.spanTagAnnotationHandler.addAnnotatedParameters(this.tracer.currentSpanCustomizer(), spanInvocation.getPjp());
        }
        this.addTags(invocation, span);
    }

    void after(Span span, boolean isNewSpan, String log, boolean hasLog) {
        if (hasLog) {
            this.logEvent(span, String.format(AnnotationSpanDocumentation.Events.AFTER.getValue(), log));
        }
        if (isNewSpan) {
            span.end();
        }
    }

    void onFailure(Span span, String log, boolean hasLog, Throwable e) {
        if (logger.isDebugEnabled()) {
            logger.debug("Exception occurred while trying to continue the pointcut", e);
        }
        if (hasLog) {
            this.logEvent(span, String.format(AnnotationSpanDocumentation.Events.AFTER_FAILURE.getValue(), log));
        }
        span.error(e);
    }

    void addTags(MethodInvocation invocation, Span span) {
        if (invocation instanceof SpanAspectMethodInvocation) {
            SpanAspectMethodInvocation methodInvocation = (SpanAspectMethodInvocation)invocation;
            span.tag(AnnotationSpanDocumentation.Tags.CLASS.asString(), methodInvocation.getPjp().getTarget().getClass().getSimpleName());
        }
        span.tag(AnnotationSpanDocumentation.Tags.METHOD.asString(), invocation.getMethod().getName());
    }

    void logEvent(Span span, String name) {
        if (span == null) {
            logger.warn("You were trying to continue a span which was null. Please remember that if two proxied methods are calling each other from the same class then the aspect will not be properly resolved");
            return;
        }
        span.event(name);
    }

    String log(ContinueSpan continueSpan) {
        if (continueSpan != null) {
            return continueSpan.log();
        }
        return "";
    }
}

