/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.bulkinsert;

import io.milvus.exception.ParamException;
import lombok.NonNull;

public class ListBulkInsertTasksParam {
    private final String collectionName;
    private final int limit;

    private ListBulkInsertTasksParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.collectionName = builder.collectionName;
        this.limit = builder.limit;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "ListBulkInsertTasksParam{collectionName='" + this.collectionName + '\'' + ", limit=" + this.limit + '}';
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public int getLimit() {
        return this.limit;
    }

    public static final class Builder {
        private String collectionName = "";
        private Integer limit = 0;

        private Builder() {
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withLimit(@NonNull Integer limit) {
            if (limit == null) {
                throw new NullPointerException("limit is marked non-null but is null");
            }
            this.limit = limit;
            if (this.limit < 0) {
                this.limit = 0;
            }
            return this;
        }

        public ListBulkInsertTasksParam build() throws ParamException {
            return new ListBulkInsertTasksParam(this);
        }
    }
}

