/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.dml;

import com.alibaba.fastjson.JSONObject;
import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;

public class InsertParam {
    protected final List<Field> fields;
    protected final List<JSONObject> rows;
    protected final String databaseName;
    protected final String collectionName;
    protected final String partitionName;
    protected final int rowCount;

    protected InsertParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.partitionName = builder.partitionName;
        this.fields = builder.fields;
        this.rowCount = builder.rowCount;
        this.rows = builder.rows;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        String baseStr = "InsertParam{collectionName='" + this.collectionName + '\'' + ", partitionName='" + this.partitionName + '\'' + ", rowCount=" + this.rowCount;
        if (!CollectionUtils.isEmpty(this.fields)) {
            return baseStr + ", columns=" + this.fields + '}';
        }
        return baseStr + '}';
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public List<JSONObject> getRows() {
        return this.rows;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public static class Field {
        private final String name;
        private final List<?> values;

        public Field(String name, List<?> values) {
            this.name = name;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public List<?> getValues() {
            return this.values;
        }

        public String toString() {
            return "Field{fieldName='" + this.name + '\'' + ", row_count=" + this.values.size() + '}';
        }

        public static FieldBuilder builder() {
            return new FieldBuilder();
        }

        public static class FieldBuilder {
            private String name;
            private List<?> values;

            FieldBuilder() {
            }

            public FieldBuilder name(String name) {
                this.name = name;
                return this;
            }

            public FieldBuilder values(List<?> values) {
                this.values = values;
                return this;
            }

            public Field build() {
                return new Field(this.name, this.values);
            }

            public String toString() {
                return "InsertParam.Field.FieldBuilder(name=" + this.name + ", values=" + this.values + ")";
            }
        }
    }

    public static class Builder {
        protected String databaseName;
        protected String collectionName;
        protected String partitionName = "";
        protected List<Field> fields;
        protected List<JSONObject> rows;
        protected int rowCount;

        protected Builder() {
        }

        public Builder withDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder withCollectionName(@NonNull String collectionName) {
            if (collectionName == null) {
                throw new NullPointerException("collectionName is marked non-null but is null");
            }
            this.collectionName = collectionName;
            return this;
        }

        public Builder withPartitionName(@NonNull String partitionName) {
            if (partitionName == null) {
                throw new NullPointerException("partitionName is marked non-null but is null");
            }
            this.partitionName = partitionName;
            return this;
        }

        public Builder withFields(@NonNull List<Field> fields) {
            if (fields == null) {
                throw new NullPointerException("fields is marked non-null but is null");
            }
            this.fields = fields;
            return this;
        }

        public Builder withRows(@NonNull List<JSONObject> rows) {
            if (rows == null) {
                throw new NullPointerException("rows is marked non-null but is null");
            }
            this.rows = rows;
            return this;
        }

        public InsertParam build() throws ParamException {
            int count;
            ParamUtils.CheckNullEmptyString(this.collectionName, "Collection name");
            if (CollectionUtils.isEmpty(this.fields) && CollectionUtils.isEmpty(this.rows)) {
                throw new ParamException("Fields and Rows are empty, use withFields() or withRows() to input data.");
            }
            if (CollectionUtils.isNotEmpty(this.fields) && CollectionUtils.isNotEmpty(this.rows)) {
                throw new ParamException("Only one of Fields or Rows is allowed to be non-empty.");
            }
            if (CollectionUtils.isNotEmpty(this.fields)) {
                if (this.fields.get(0) == null) {
                    throw new ParamException("Field cannot be null. If the field is auto-id, just ignore it from withFields()");
                }
                count = this.fields.get(0).getValues().size();
                this.checkFields(count);
            } else {
                count = this.rows.size();
                this.checkRows();
            }
            this.rowCount = count;
            if (count == 0) {
                throw new ParamException("Zero row count is not allowed");
            }
            return new InsertParam(this);
        }

        protected void checkFields(int count) {
            for (Field field : this.fields) {
                if (field == null) {
                    throw new ParamException("Field cannot be null. If the field is auto-id, just ignore it from withFields()");
                }
                ParamUtils.CheckNullEmptyString(field.getName(), "Field name");
                if (field.getValues() != null && !field.getValues().isEmpty()) continue;
                throw new ParamException("Field value cannot be empty. If the field is auto-id, just ignore it from withFields()");
            }
            for (Field field : this.fields) {
                if (field.getValues().size() == count) continue;
                throw new ParamException("Row count of fields must be equal");
            }
        }

        protected void checkRows() {
            for (JSONObject row : this.rows) {
                if (row == null) {
                    throw new ParamException("Row cannot be null. If the field is auto-id, just ignore it from withRows()");
                }
                for (String rowFieldName : row.keySet()) {
                    ParamUtils.CheckNullEmptyString(rowFieldName, "Field name");
                    if (row.get((Object)rowFieldName) != null) continue;
                    throw new ParamException("Field value cannot be empty. If the field is auto-id, just ignore it from withRows()");
                }
            }
        }
    }
}

